/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.VolumeFilter;
import com.aliyun.odps.VolumePartition;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Volume
extends LazyLoad {
    private VolumeModel model;
    private String project;
    private String name;
    private RestClient client;

    Volume(VolumeModel model, String project, RestClient client) {
        this.model = model;
        this.name = model.name;
        this.project = project;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildVolumeResource(this.project, this.name);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("meta", null);
        Response resp = this.client.request(resource, "GET", params, null, null);
        try {
            this.model = JAXBUtils.unmarshal(resp, VolumeModel.class);
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(resp.getHeader("Last_Modified"));
            this.model.createdTime = DateUtils.parseRfc822Date(resp.getHeader("x-odps-creation-time"));
            this.model.owner = resp.getHeader("x-odps-owner");
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + VolumeModel.class, e);
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public long getLength() {
        if (this.model.length == null) {
            this.lazyLoad();
        }
        return this.model.length;
    }

    public int getFileCount() {
        if (this.model.fileNumber == null) {
            this.lazyLoad();
        }
        return this.model.fileNumber;
    }

    public VolumePartition getVolumePartition(String partitionName) {
        VolumePartition.VolumePartitionModel model = new VolumePartition.VolumePartitionModel();
        model.name = partitionName;
        return new VolumePartition(model, this.project, this.name, this.client);
    }

    public void deleteVolumePartition(String partitionName) throws OdpsException {
        String resource = ResourceBuilder.buildVolumePartitionResource(this.project, this.name, partitionName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    public Iterator<VolumePartition> getPartitionIterator() {
        return this.getPartitionIterator(null);
    }

    public Iterator<VolumePartition> getPartitionIterator(final VolumeFilter filter) {
        return new ListIterator<VolumePartition>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<VolumePartition> list() {
                ArrayList<VolumePartition> partitions = new ArrayList<VolumePartition>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ResourceBuilder.buildVolumeResource(Volume.this.project, Volume.this.name);
                try {
                    ListPartitionsResponse resp = Volume.this.client.request(ListPartitionsResponse.class, resource, "GET", this.params);
                    for (VolumePartition.VolumePartitionModel model : ((ListPartitionsResponse)resp).partitions.partitions) {
                        VolumePartition t = new VolumePartition(model, Volume.this.project, Volume.this.name, Volume.this.client);
                        partitions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return partitions;
            }
        };
    }

    @XmlRootElement(name="Volume")
    private static class ListPartitionsResponse {
        @XmlElement(name="Partitions")
        private Partitions partitions;
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListPartitionsResponse() {
        }
    }

    @XmlRootElement(name="Partitions")
    private static class Partitions {
        @XmlElement(name="Partition")
        List<VolumePartition.VolumePartitionModel> partitions = new ArrayList<VolumePartition.VolumePartitionModel>();

        private Partitions() {
        }
    }

    @XmlRootElement(name="Meta")
    static class VolumeModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Comment")
        String comment;
        @XmlElement(name="Length")
        Long length;
        @XmlElement(name="FileNumber")
        Integer fileNumber;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date createdTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date lastModifiedTime;

        VolumeModel() {
        }
    }
}

