/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Topology;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.StreamTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Topologies
implements Iterable<Topology> {
    RestClient client;
    Odps odps;

    public Topologies(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Topology get(String topologyName) {
        return this.get(this.getDefaultProjectName(), topologyName);
    }

    public Topology get(String projectName, String topologyName) {
        Topology.TopologyModel model = new Topology.TopologyModel();
        model.name = topologyName;
        Topology t = new Topology(model, projectName, this.client);
        return t;
    }

    public void create(String topologyName, String description) throws OdpsException {
        this.create(this.getDefaultProjectName(), topologyName, description);
    }

    public void create(String projectName, String topologyName, String description) throws OdpsException {
        if (projectName == null || topologyName == null) {
            throw new IllegalArgumentException();
        }
        StreamTask task = new StreamTask();
        task.setName("CREATE_TOPOLOGY_TASK");
        task.setProperty("operation", "CREATE_TOPOLOGY");
        task.setProperty("topology", topologyName);
        task.setProperty("description", description);
        this.odps.instances().create(projectName, task).waitForSuccess();
    }

    public void delete(String topologyName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), topologyName);
    }

    public void delete(String projectName, String topologyName) throws OdpsException {
        StreamTask task = new StreamTask();
        task.setName("DELETE_TOPOLOGY_TASK");
        task.setProperty("operation", "DELETE_TOPOLOGY");
        task.setProperty("topology", topologyName);
        this.odps.instances().create(projectName, task).waitForSuccess();
    }

    @Override
    public Iterator<Topology> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<Topology> iterator(final String projectName) {
        return new ListIterator<Topology>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Topology> list() {
                ArrayList<Topology> topologies = new ArrayList<Topology>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && (lastMarker == null || lastMarker.length() == 0)) {
                    return null;
                }
                String resource = ResourceBuilder.buildTopologiesResource(projectName);
                try {
                    ListTopologiesResponse resp = Topologies.this.client.request(ListTopologiesResponse.class, resource, "GET", this.params);
                    for (Topology.TopologyModel model : resp.topologies) {
                        Topology t = new Topology(model, projectName, Topologies.this.client);
                        topologies.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return topologies;
            }
        };
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @XmlRootElement(name="Topologies")
    private static class ListTopologiesResponse {
        @XmlElement(name="Topology")
        private List<Topology.TopologyModel> topologies = new ArrayList<Topology.TopologyModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListTopologiesResponse() {
        }
    }
}

