/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Instances;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.SQLTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Tables
implements Iterable<Table> {
    private RestClient client;
    private Odps odps;

    Tables(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Table get(String tableName) {
        return this.get(this.getDefaultProjectName(), tableName);
    }

    public Table get(String projectName, String tableName) {
        Table.TableModel model = new Table.TableModel();
        model.name = tableName;
        Table t = new Table(model, projectName, this.odps);
        return t;
    }

    public boolean exists(String tableName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), tableName);
    }

    public boolean exists(String projectName, String tableName) throws OdpsException {
        try {
            Table t = this.get(projectName, tableName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Table> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Table> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Table> iterator(TableFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Table> iterator(final String projectName, final TableFilter filter) {
        return new ListIterator<Table>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Table> list() {
                ArrayList<Table> tables = new ArrayList<Table>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ResourceBuilder.buildTablesResource(projectName);
                try {
                    ListTablesResponse resp = Tables.this.client.request(ListTablesResponse.class, resource, "GET", this.params);
                    for (Table.TableModel model : resp.tables) {
                        Table t = new Table(model, projectName, Tables.this.odps);
                        tables.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return tables;
            }
        };
    }

    public void create(String tableName, TableSchema schema) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema);
    }

    public void create(String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema) throws OdpsException {
        this.create(projectName, tableName, schema, false);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        if (projectName == null || tableName == null || schema == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (ifNotExists) {
            sb.append(" IF NOT EXISTS ");
        }
        sb.append(projectName).append(".").append(tableName).append(" (");
        List<Column> columns = schema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column c = columns.get(i);
            sb.append(c.getName()).append(" ").append(OdpsType.getFullTypeString((OdpsType)c.getType(), (List)c.getGenericTypeList()));
            if (i + 1 >= columns.size()) continue;
            sb.append(',');
        }
        sb.append(')');
        List<Column> pcolumns = schema.getPartitionColumns();
        if (pcolumns.size() > 0) {
            sb.append(" PARTITIONED BY (");
            for (int i = 0; i < pcolumns.size(); ++i) {
                Column c = pcolumns.get(i);
                sb.append(c.getName()).append(" ").append(OdpsType.getFullTypeString((OdpsType)c.getType(), (List)c.getGenericTypeList()));
                if (i + 1 >= pcolumns.size()) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        sb.append(';');
        String taskName = "SQLCreateTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(sb.toString());
        Instances instances = new Instances(this.odps);
        Instance instance = instances.create(task);
        instance.waitForSuccess();
    }

    public void delete(String tableName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName);
    }

    public void delete(String tableName, boolean ifExists) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName, ifExists);
    }

    public void delete(String projectName, String tableName) throws OdpsException {
        this.delete(projectName, tableName, false);
    }

    public void delete(String projectName, String tableName, boolean ifExists) throws OdpsException {
        if (projectName == null || tableName == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        if (ifExists) {
            sb.append(" IF EXISTS ");
        }
        sb.append(projectName).append(".").append(tableName).append(";");
        String taskName = "SQLDropTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(sb.toString());
        Instances instances = new Instances(this.odps);
        Instance instance = instances.create(task);
        instance.waitForSuccess();
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @XmlRootElement(name="Tables")
    private static class ListTablesResponse {
        @XmlElement(name="Table")
        private List<Table.TableModel> tables = new ArrayList<Table.TableModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;

        private ListTablesResponse() {
        }
    }
}

