/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableSchema {
    private ArrayList<Column> columns = new ArrayList();
    private ArrayList<Column> partitionColumns = new ArrayList();
    private HashMap<String, Integer> nameMap = new HashMap();
    private HashMap<String, Integer> partitionNameMap = new HashMap();

    public void addColumn(Column c) {
        if (c == null) {
            throw new IllegalArgumentException("Column is null.");
        }
        if (this.nameMap.containsKey(c.getName()) || this.partitionNameMap.containsKey(c.getName())) {
            throw new IllegalArgumentException("Column " + c.getName() + " duplicated.");
        }
        this.nameMap.put(c.getName(), this.columns.size());
        this.columns.add(c);
    }

    public void addPartitionColumn(Column c) {
        if (c == null) {
            throw new IllegalArgumentException("Column is null.");
        }
        if (this.nameMap.containsKey(c.getName()) || this.partitionNameMap.containsKey(c.getName())) {
            throw new IllegalArgumentException("Column " + c.getName() + " duplicated.");
        }
        this.partitionNameMap.put(c.getName(), this.partitionColumns.size());
        this.partitionColumns.add(c);
    }

    public Column getColumn(int idx) {
        if (idx < 0 || idx >= this.columns.size()) {
            throw new IllegalArgumentException("idx out of range");
        }
        return this.columns.get(idx);
    }

    public int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }

    public Column getColumn(String name) {
        return this.columns.get(this.getColumnIndex(name));
    }

    public List<Column> getColumns() {
        return (List)this.columns.clone();
    }

    public List<Column> getPartitionColumns() {
        return (List)this.partitionColumns.clone();
    }

    public Column getPartitionColumn(String name) {
        return this.partitionColumns.get(this.getPartitionColumnIndex(name));
    }

    public int getPartitionColumnIndex(String name) {
        return this.partitionNameMap.get(name);
    }

    public boolean containsColumn(String name) {
        return this.nameMap.containsKey(name);
    }

    public boolean containsPartitionColumn(String name) {
        return this.partitionNameMap.containsKey(name);
    }
}

