/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.task.GalaxyTask;
import java.util.Map;

public class StreamJobs {
    RestClient client;
    Odps odps;

    public StreamJobs(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public String list() throws OdpsException {
        GalaxyTask task = new GalaxyTask();
        String taskName = "LIST_STREAMJOB_TASK";
        task.setName(taskName);
        task.setOperationType("LIST_STREAMJOB");
        return this.runInstance(this.getDefaultProjectName(), task);
    }

    public String create(String streamJobName, String sql, Map<String, String> hints) throws OdpsException {
        return this.create(this.getDefaultProjectName(), streamJobName, sql, hints);
    }

    public String create(String projectName, String streamJobName, String sql, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        if (sql.length() == 0) {
            throw new OdpsException("Sql can not be empty");
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("CREATE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("CREATE_STREAMJOB");
        task.setSql(sql);
        if (hints != null) {
            try {
                String json = JacksonParser.getObjectMapper().writeValueAsString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    public String delete(String streamJobName) throws OdpsException {
        return this.delete(this.getDefaultProjectName(), streamJobName);
    }

    public String delete(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("DELETE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("DELETE_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String getStatus(String streamJobName) throws OdpsException {
        return this.getStatus(this.getDefaultProjectName(), streamJobName);
    }

    public String getStatus(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("GETSTATUS_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("STATUS_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String pause(String streamJobName) throws OdpsException {
        return this.pause(this.getDefaultProjectName(), streamJobName);
    }

    public String pause(String projectName, String streamJobName) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("PAUSE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("PAUSE_STREAMJOB");
        return this.runInstance(projectName, task);
    }

    public String resume(String streamJobName, Map<String, String> hints) throws OdpsException {
        return this.resume(this.getDefaultProjectName(), streamJobName, hints);
    }

    public String resume(String projectName, String streamJobName, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("RESUME_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("RESUME_STREAMJOB");
        if (hints != null) {
            try {
                String json = JacksonParser.getObjectMapper().writeValueAsString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    public String rebalance(String streamJobName, Map<String, String> hints) throws OdpsException {
        return this.rebalance(this.getDefaultProjectName(), streamJobName, hints);
    }

    public String rebalance(String projectName, String streamJobName, Map<String, String> hints) throws OdpsException {
        if (projectName == null || streamJobName == null) {
            throw new IllegalArgumentException();
        }
        GalaxyTask task = new GalaxyTask();
        task.setName("REBALANCE_STREAMJOB_TASK");
        task.setStreamJobName(streamJobName);
        task.setOperationType("REBALANCE_STREAMJOB");
        if (hints != null) {
            try {
                String json = JacksonParser.getObjectMapper().writeValueAsString(hints);
                task.setSettings(json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return this.runInstance(projectName, task);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private String runInstance(String projectName, GalaxyTask task) throws OdpsException {
        Instance instance = this.odps.instances().create(projectName, task);
        instance.waitForSuccess();
        Map<String, String> resultMap = instance.getTaskResults();
        return resultMap.get(task.getName());
    }
}

