/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.rest.RestClient;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Projects {
    private RestClient client;

    Projects(RestClient client) {
        this.client = client;
    }

    public Project get() throws OdpsException {
        return this.get(this.getDefaultProjectName());
    }

    public Project get(String projectName) throws OdpsException {
        Project.ProjectModel model = new Project.ProjectModel();
        model.name = projectName;
        Project prj = new Project(model, this.client);
        return prj;
    }

    public boolean exists(String projectName) throws OdpsException {
        try {
            Project project = this.get(projectName);
            project.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @XmlRootElement(name="Projects")
    private static class ListProjectResponse {
        @XmlElement(name="Project")
        private List<Project.ProjectModel> projects = new LinkedList<Project.ProjectModel>();
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private int maxItems;

        private ListProjectResponse() {
        }
    }
}

