/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Functions;
import com.aliyun.odps.Instances;
import com.aliyun.odps.Projects;
import com.aliyun.odps.Resources;
import com.aliyun.odps.StreamJobs;
import com.aliyun.odps.Tables;
import com.aliyun.odps.Topologies;
import com.aliyun.odps.Volumes;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.rest.RestClient;
import java.net.URI;
import java.net.URISyntaxException;

public class Odps {
    private static final String defaultEndpoint = "http://service.odps.aliyun.com/api";
    private Account account;
    private String endpoint;
    private String defaultProject;
    private Projects projects;
    private Tables tables;
    private Instances instances;
    private Resources resources;
    private Functions functions;
    private Volumes volumes;
    private Topologies topologies;
    private StreamJobs streamJobs;
    protected RestClient client;
    private String userAgent;
    private String logViewHost;

    public Odps(Account account) {
        this.account = account;
        this.client = new RestClient(new DefaultTransport());
        this.client.setAccount(account);
        this.setUserAgent("");
        this.setEndpoint(defaultEndpoint);
        this.projects = new Projects(this.client);
        this.tables = new Tables(this);
        this.instances = new Instances(this);
        this.resources = new Resources(this);
        this.functions = new Functions(this);
        this.volumes = new Volumes(this.client);
        this.topologies = new Topologies(this);
        this.streamJobs = new StreamJobs(this);
    }

    public Odps(Odps odps) {
        this(odps.account);
        this.setDefaultProject(odps.getDefaultProject());
        this.setUserAgent(odps.getUserAgent());
        this.setEndpoint(odps.getEndpoint());
        this.setLogViewHost(odps.getLogViewHost());
        this.client.setIgnoreCerts(odps.getRestClient().isIgnoreCerts());
    }

    public Projects projects() {
        return this.projects;
    }

    public Tables tables() {
        return this.tables;
    }

    public Instances instances() {
        return this.instances;
    }

    public Resources resources() {
        return this.resources;
    }

    public Functions functions() {
        return this.functions;
    }

    public Volumes volumes() {
        return this.volumes;
    }

    public Topologies topologies() {
        return this.topologies;
    }

    public StreamJobs streamJobs() {
        return this.streamJobs;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        try {
            URI uri = new URI(endpoint);
            this.endpoint = uri.toString();
            this.client.setEndpoint(this.endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
        this.client.setDefaultProject(defaultProject);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.client.setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Odps clone() {
        return new Odps(this);
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public String getLogViewHost() {
        return this.logViewHost;
    }

    public void setLogViewHost(String host) {
        this.logViewHost = host;
    }
}

