/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.jdbc.OdpsDatabaseMetaData;
import com.aliyun.odps.jdbc.OdpsPreparedStatement;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.ConnectionResource;
import com.aliyun.odps.jdbc.utils.LogConsoleHandler;
import com.aliyun.odps.jdbc.utils.Utils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OdpsConnection
extends WrapperAdapter
implements Connection {
    private final Odps odps;
    private final Properties info;
    private final List<Statement> stmtHandles;
    private final String charset;
    private final String logviewHost;
    protected final int lifecycle;
    private boolean isClosed = false;
    protected Logger log;
    private SQLWarning warningChain = null;
    private final Properties sqlTaskProperties = new Properties();

    OdpsConnection(String url, Properties info) {
        int lifecycle;
        ConnectionResource connRes = new ConnectionResource(url, info);
        String accessId = connRes.getAccessId();
        String accessKey = connRes.getAccessKey();
        String charset = connRes.getCharset();
        String project = connRes.getProject();
        String endpoint = connRes.getEndpoint();
        String logviewHost = connRes.getLogview();
        String logLevel = connRes.getLogLevel();
        try {
            lifecycle = Integer.parseInt(connRes.getLifecycle());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("lifecycle is expected to be an integer");
        }
        this.log = Logger.getLogger(UUID.randomUUID().toString().substring(24));
        if (logLevel.equalsIgnoreCase("fatal") || logLevel.equalsIgnoreCase("severe")) {
            this.log.setLevel(Level.SEVERE);
        } else if (logLevel.equalsIgnoreCase("warning")) {
            this.log.setLevel(Level.WARNING);
        } else if (logLevel.equalsIgnoreCase("debug") || logLevel.equalsIgnoreCase("fine")) {
            this.log.setLevel(Level.FINEST);
        } else {
            this.log.setLevel(Level.INFO);
        }
        this.log.setUseParentHandlers(false);
        this.log.addHandler(LogConsoleHandler.getInstance());
        String version = Utils.retrieveVersion();
        this.log.info("ODPS JDBC driver, Version " + version);
        this.log.info(String.format("endpoint=%s, project=%s", endpoint, project));
        this.log.fine(String.format("charset=%s, logview=%s, lifecycle=%d, loglevel=%s", charset, logviewHost, lifecycle, logLevel));
        AliyunAccount account = new AliyunAccount(accessId, accessKey);
        this.log.fine("debug mode on");
        this.odps = new Odps((Account)account);
        this.odps.setEndpoint(endpoint);
        this.odps.setDefaultProject(project);
        this.odps.setUserAgent("odps-jdbc-" + version);
        this.info = info;
        this.charset = charset;
        this.logviewHost = logviewHost;
        this.lifecycle = lifecycle;
        this.stmtHandles = new ArrayList<Statement>();
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql) throws SQLException {
        OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Statement with resultset type: " + resultSetType + " is not supported");
        }
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("Statement with resultset concurrency: " + resultSetConcurrency + " is not supported");
        }
        boolean isResultSetScrollable = resultSetType == 1004;
        OdpsPreparedStatement stmt = new OdpsPreparedStatement(this, sql, isResultSetScrollable);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " to false is not supported!!!");
            throw new SQLFeatureNotSupportedException("enabling autocommit is not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            for (Statement stmt : this.stmtHandles) {
                if (stmt == null) continue;
                stmt.close();
            }
        }
        this.isClosed = true;
        this.log.info("connection closed");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new OdpsDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
            throw new SQLFeatureNotSupportedException("enabling read-only is not supported");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsStatement createStatement() throws SQLException {
        this.checkClosed();
        OdpsStatement stmt = new OdpsStatement(this, false);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public OdpsStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean isResultSetScrollable;
        this.checkClosed();
        switch (resultSetType) {
            case 1003: {
                isResultSetScrollable = false;
                break;
            }
            case 1004: {
                isResultSetScrollable = true;
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException("only support statement with ResultSet type: TYPE_SCROLL_INSENSITIVE, ResultSet.TYPE_FORWARD_ONLY");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException("only support statement with ResultSet concurrency: CONCUR_READ_ONLY");
            }
        }
        OdpsStatement stmt = new OdpsStatement(this, isResultSetScrollable);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout value was negative");
        }
        try {
            boolean exists = this.odps.projects().exists("123");
            return true;
        }
        catch (OdpsException e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.info.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.info.put(name, value);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.info;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.info.getProperty(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.odps.setDefaultProject(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.odps.getDefaultProject();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.log.severe(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported!!!");
        throw new SQLFeatureNotSupportedException();
    }

    public Odps getOdps() {
        return this.odps;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the connection has already been closed");
        }
    }

    protected String getCharset() {
        return this.charset;
    }

    protected String getLogviewHost() {
        return this.logviewHost;
    }

    public Properties getSqlTaskProperties() {
        return this.sqlTaskProperties;
    }
}

