/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.utils;

import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class EncryptionContextUtils {
    private static final Gson gson = new GsonBuilder().create();
    private static final String SHA_256 = "SHA-256";

    private EncryptionContextUtils() {
    }

    public static byte[] sortAndEncode(String encryptionContext, Charset charset) {
        if (StringUtils.isEmpty((CharSequence)encryptionContext)) {
            return null;
        }
        Map map = (Map)gson.fromJson(encryptionContext, Map.class);
        if (map == null) {
            throw new IllegalArgumentException("param[EncryptionContext] is invalid");
        }
        ArrayList keyList = new ArrayList(map.keySet());
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            sb.append(key).append("=").append(map.get(key)).append('&');
        }
        if (sb.indexOf("&") > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return EncryptionContextUtils.getSha256(sb.toString(), charset);
    }

    public static byte[] getSha256(String str, Charset charset) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
            messageDigest.update(str.getBytes(charset));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

