/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.EncryptResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyun.kms.utils.ArrayUtils;
import com.aliyun.kms.utils.EncryptionContextUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EncryptTransferHandler
implements KmsTransferHandler<com.aliyun.dkms.gcs.sdk.models.EncryptRequest, EncryptResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public EncryptTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public <T extends AcsResponse> com.aliyun.dkms.gcs.sdk.models.EncryptRequest buildDKMSRequest(AcsRequest<T> request, RuntimeOptions runtimeOptions) throws ClientException {
        EncryptRequest encryptKmsRequest = (EncryptRequest)request;
        if (StringUtils.isEmpty((CharSequence)encryptKmsRequest.getPlaintext())) {
            throw this.newMissingParameterClientException("Plaintext");
        }
        com.aliyun.dkms.gcs.sdk.models.EncryptRequest encryptDKmsRequest = new com.aliyun.dkms.gcs.sdk.models.EncryptRequest();
        encryptDKmsRequest.setKeyId(encryptKmsRequest.getKeyId());
        encryptDKmsRequest.setPlaintext(encryptKmsRequest.getPlaintext().getBytes(StandardCharsets.UTF_8));
        String encryptionContext = encryptKmsRequest.getEncryptionContext();
        if (!StringUtils.isEmpty((CharSequence)encryptionContext)) {
            encryptDKmsRequest.setAad(EncryptionContextUtils.sortAndEncode(encryptionContext, StandardCharsets.UTF_8));
        }
        return encryptDKmsRequest;
    }

    @Override
    public EncryptResponse callDKMS(com.aliyun.dkms.gcs.sdk.models.EncryptRequest encryptRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.encryptWithOptions(encryptRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, EncryptResponse response) throws ClientException {
        String keyVersionId;
        com.aliyuncs.kms.model.v20160120.EncryptResponse encryptKmsResponse = new com.aliyuncs.kms.model.v20160120.EncryptResponse();
        encryptKmsResponse.setKeyId(response.getKeyId());
        Map responseHeaders = response.getResponseHeaders();
        if (responseHeaders == null || responseHeaders.size() == 0 || StringUtils.isEmpty((CharSequence)(keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid")))) {
            throw new ClientException(String.format("Can not found response headers parameter[%s]", "x-kms-migrationkeyversionid"));
        }
        byte[] ciphertextBlob = ArrayUtils.concatAll(keyVersionId.getBytes(StandardCharsets.UTF_8), response.getIv(), response.getCiphertextBlob());
        encryptKmsResponse.setKeyVersionId(keyVersionId);
        encryptKmsResponse.setCiphertextBlob(base64.encodeToString(ciphertextBlob));
        encryptKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)encryptKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

