/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.VerifyRequest;
import com.aliyun.dkms.gcs.sdk.models.VerifyResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.AsymmetricVerifyRequest;
import com.aliyuncs.kms.model.v20160120.AsymmetricVerifyResponse;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsymmetricVerifyTransferHandler
implements KmsTransferHandler<VerifyRequest, VerifyResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public AsymmetricVerifyTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public VerifyRequest buildDKMSRequest(AcsRequest request, RuntimeOptions runtimeOptions) throws ClientException {
        AsymmetricVerifyRequest asymmetricVerifyKmsRequest = (AsymmetricVerifyRequest)request;
        if (StringUtils.isEmpty((CharSequence)asymmetricVerifyKmsRequest.getDigest())) {
            throw this.newMissingParameterClientException("Digest");
        }
        if (StringUtils.isEmpty((CharSequence)asymmetricVerifyKmsRequest.getValue())) {
            throw this.newMissingParameterClientException("Value");
        }
        VerifyRequest verifyDKmsRequest = new VerifyRequest();
        verifyDKmsRequest.setKeyId(asymmetricVerifyKmsRequest.getKeyId());
        verifyDKmsRequest.setAlgorithm(asymmetricVerifyKmsRequest.getAlgorithm());
        verifyDKmsRequest.setMessage(base64.decode(asymmetricVerifyKmsRequest.getDigest()));
        verifyDKmsRequest.setMessageType("DIGEST");
        verifyDKmsRequest.setSignature(base64.decode(asymmetricVerifyKmsRequest.getValue()));
        final String keyVersionId = asymmetricVerifyKmsRequest.getKeyVersionId();
        if (!StringUtils.isEmpty((CharSequence)keyVersionId)) {
            verifyDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
                {
                    this.put("x-kms-migrationkeyversionid", keyVersionId);
                }
            });
        }
        return verifyDKmsRequest;
    }

    @Override
    public VerifyResponse callDKMS(VerifyRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.verifyWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, VerifyResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        AsymmetricVerifyResponse asymmetricVerifyKmsResponse = new AsymmetricVerifyResponse();
        asymmetricVerifyKmsResponse.setKeyId(response.getKeyId());
        asymmetricVerifyKmsResponse.setKeyVersionId(keyVersionId);
        asymmetricVerifyKmsResponse.setValue(response.getValue());
        asymmetricVerifyKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)asymmetricVerifyKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

