/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.signer.ServiceSignature;
import com.alibaba.sdk.android.oss.signer.SignParameters;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    public static String composeRequestAuthorization(String accessKeyId, String signature) {
        return "OSS " + accessKeyId + ":" + signature;
    }

    public static String buildCanonicalString(String method, String resourcePath, RequestMessage request, String expires) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append("\n");
        Map headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry header : headers.entrySet()) {
                String lowerKey;
                if (header.getKey() == null || !(lowerKey = ((String)header.getKey()).toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith("x-oss-")) continue;
                headersToSign.put(lowerKey, ((String)header.getValue()).trim());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        for (Map.Entry entry : headersToSign.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("x-oss-")) {
                canonicalString.append(key).append(':').append(value);
            } else {
                canonicalString.append(value);
            }
            canonicalString.append("\n");
        }
        canonicalString.append(SignUtils.buildCanonicalizedResource(resourcePath, request.getParameters()));
        return canonicalString.toString();
    }

    public static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        OSSUtils.assertTrue(resourcePath.startsWith("/"), "Resource path should start with slash character");
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separator = 63;
            for (Object paramName : parameterNames) {
                if (!SignParameters.SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separator);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (paramValue != null && !paramValue.trim().isEmpty()) {
                    builder.append("=").append(paramValue);
                }
                separator = 38;
            }
        }
        return builder.toString();
    }

    public static String buildSignature(String secretAccessKey, String httpMethod, String resourcePath, RequestMessage request) {
        String canonicalString = SignUtils.buildCanonicalString(httpMethod, resourcePath, request, null);
        return ServiceSignature.create().computeSignature(secretAccessKey, canonicalString);
    }
}

