/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import android.util.Base64;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import okio.ByteString;

public class BinaryUtil {
    public static String toBase64String(byte[] binaryData) {
        return new String(Base64.encode((byte[])binaryData, (int)0)).trim();
    }

    public static byte[] fromBase64String(String base64String) {
        return Base64.decode((String)base64String, (int)0);
    }

    public static byte[] calculateMd5(FileDescriptor fileDescriptor) throws IOException {
        byte[] md5;
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[10240];
            FileInputStream is = new FileInputStream(fileDescriptor);
            while ((len = is.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            is.close();
            md5 = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found.");
        }
        return md5;
    }

    public static byte[] calculateMd5(byte[] binaryData) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found.");
        }
        messageDigest.update(binaryData);
        return messageDigest.digest();
    }

    public static byte[] calculateMd5(String filePath) throws IOException {
        byte[] md5;
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[10240];
            FileInputStream is = new FileInputStream(new File(filePath));
            while ((len = is.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            is.close();
            md5 = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found.");
        }
        return md5;
    }

    public static String calculateMd5Str(byte[] binaryData) {
        return BinaryUtil.getMd5StrFromBytes(BinaryUtil.calculateMd5(binaryData));
    }

    public static String calculateMd5Str(String filePath) throws IOException {
        return BinaryUtil.getMd5StrFromBytes(BinaryUtil.calculateMd5(filePath));
    }

    public static String calculateMd5Str(FileDescriptor fileDescriptor) throws IOException {
        return BinaryUtil.getMd5StrFromBytes(BinaryUtil.calculateMd5(fileDescriptor));
    }

    public static String calculateBase64Md5(byte[] binaryData) {
        return BinaryUtil.toBase64String(BinaryUtil.calculateMd5(binaryData));
    }

    public static String calculateBase64Md5(String filePath) throws IOException {
        return BinaryUtil.toBase64String(BinaryUtil.calculateMd5(filePath));
    }

    public static String calculateBase64Md5(FileDescriptor fileDescriptor) throws IOException {
        return BinaryUtil.toBase64String(BinaryUtil.calculateMd5(fileDescriptor));
    }

    public static String getMd5StrFromBytes(byte[] md5bytes) {
        if (md5bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < md5bytes.length; ++i) {
            sb.append(String.format("%02x", md5bytes[i]));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToSHA1(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            int numRead = 0;
            while (numRead != -1) {
                numRead = ((InputStream)inputStream).read(buffer);
                if (numRead <= 0) continue;
                digest.update(buffer, 0, numRead);
            }
            byte[] sha1Bytes = digest.digest();
            String string = BinaryUtil.convertHashToString(sha1Bytes);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToSHA1(FileDescriptor fileDescriptor) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileDescriptor);
            byte[] buffer = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            int numRead = 0;
            while (numRead != -1) {
                numRead = ((InputStream)inputStream).read(buffer);
                if (numRead <= 0) continue;
                digest.update(buffer, 0, numRead);
            }
            byte[] sha1Bytes = digest.digest();
            String string = BinaryUtil.convertHashToString(sha1Bytes);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String convertHashToString(byte[] hashBytes) {
        String returnVal = "";
        for (int i = 0; i < hashBytes.length; ++i) {
            returnVal = returnVal + Integer.toString((hashBytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return returnVal.toLowerCase();
    }

    public static byte[] calculateSha256(byte[] binaryData) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found.");
        }
        messageDigest.update(binaryData);
        return messageDigest.digest();
    }

    public static String toHex(byte[] data) {
        ByteString byteString = ByteString.of((byte[])data);
        return byteString.hex();
    }
}

