/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressTouchableResponseBody<T extends OSSRequest>
extends ResponseBody {
    private final ResponseBody mResponseBody;
    private OSSProgressCallback mProgressListener;
    private BufferedSource mBufferedSource;
    private T request;

    public ProgressTouchableResponseBody(ResponseBody responseBody, ExecutionContext context) {
        this.mResponseBody = responseBody;
        this.mProgressListener = context.getProgressCallback();
        this.request = context.getRequest();
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (ProgressTouchableResponseBody.this.mProgressListener != null && this.totalBytesRead != -1L && this.totalBytesRead != 0L) {
                    ProgressTouchableResponseBody.this.mProgressListener.onProgress(ProgressTouchableResponseBody.this.request, this.totalBytesRead, ProgressTouchableResponseBody.this.mResponseBody.contentLength());
                }
                return bytesRead;
            }
        };
    }
}

