/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.ProgressTouchableRequestBody;
import com.alibaba.sdk.android.oss.network.ProgressTouchableResponseBody;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class NetworkProgressHelper {
    public static OkHttpClient addProgressResponseListener(OkHttpClient client, final ExecutionContext context) {
        OkHttpClient newClient = client.newBuilder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body(new ProgressTouchableResponseBody(originalResponse.body(), context)).build();
            }
        }).build();
        return newClient;
    }

    public static ProgressTouchableRequestBody addProgressRequestBody(InputStream input, long contentLength, String contentType, ExecutionContext context) {
        return new ProgressTouchableRequestBody(input, contentLength, contentType, context);
    }
}

