/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.auth;

import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;

public abstract class OSSFederationCredentialProvider
extends OSSCredentialProvider {
    private volatile OSSFederationToken cachedToken;

    public abstract OSSFederationToken getFederationToken();

    public synchronized OSSFederationToken getValidFederationToken() {
        if (this.cachedToken == null || DateUtil.getFixedSkewedTimeMillis() / 1000L > this.cachedToken.getExpiration() - 300L) {
            if (this.cachedToken != null) {
                OSSLog.logDebug("token expired! current time: " + DateUtil.getFixedSkewedTimeMillis() / 1000L + " token expired: " + this.cachedToken.getExpiration());
            }
            this.cachedToken = this.getFederationToken();
        }
        return this.cachedToken;
    }

    public OSSFederationToken getCachedToken() {
        return this.cachedToken;
    }
}

