/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.SparseArray;
import com.aliya.permission.PermissionManager;
import java.util.ArrayList;
import java.util.List;

public final class ResultHelper {
    private static final String FRAGMENT_TAG = "result_fragment_tag";

    public static Activity getActivityByContext(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (PermissionManager.sDebuggable) {
            throw new IllegalArgumentException(context + " should be include activity");
        }
        return null;
    }

    @RequiresApi(api=23)
    static boolean requestPermissions(Context context, String[] permissions, int requestCode, OnPermissionsResultCallback callback) {
        InnerResultFragment requestFragment;
        Activity activity = ResultHelper.getActivityByContext(context);
        if (activity == null) {
            return false;
        }
        FragmentManager manager = activity.getFragmentManager();
        Fragment fragmentByTag = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragmentByTag instanceof InnerResultFragment) {
            requestFragment = (InnerResultFragment)fragmentByTag;
        } else {
            requestFragment = new InnerResultFragment();
            manager.beginTransaction().add((Fragment)requestFragment, FRAGMENT_TAG).commitAllowingStateLoss();
        }
        requestFragment.requestPermissionsForResult(permissions, requestCode, callback);
        return true;
    }

    public static boolean startActivityForResult(Context context, Intent intent, int requestCode, OnActivityResultCallback callback) {
        return ResultHelper.startActivityForResult(context, intent, requestCode, null, callback);
    }

    public static boolean startActivityForResult(Context context, Intent intent, int requestCode, Bundle options, OnActivityResultCallback callback) {
        if (context instanceof Activity) {
            InnerResultFragment resultFragment;
            Activity activity = (Activity)context;
            FragmentManager manager = activity.getFragmentManager();
            Fragment fragmentByTag = manager.findFragmentByTag(FRAGMENT_TAG);
            if (fragmentByTag instanceof InnerResultFragment) {
                resultFragment = (InnerResultFragment)fragmentByTag;
            } else {
                resultFragment = new InnerResultFragment();
                manager.beginTransaction().add((Fragment)resultFragment, FRAGMENT_TAG).commitAllowingStateLoss();
            }
            resultFragment.startActivityForResult(intent, requestCode, options, callback);
            return true;
        }
        return false;
    }

    public static interface OnActivityResultCallback {
        public void onActivityResult(int var1, int var2, Intent var3);
    }

    public static interface OnPermissionsResultCallback {
        public void onPermissionsResult(int var1, String[] var2, int[] var3);
    }

    public static class InnerResultFragment
    extends Fragment {
        private SparseArray<String[]> mWaitingRequestPermissions;
        private SparseArray<OnPermissionsResultCallback> mPermissionsResultCallbacks;
        private List<IntentConfig> mWaitingStartActivities;
        private List<CallbackParams> mCallbackParams = new ArrayList<CallbackParams>(1);

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (this.mWaitingRequestPermissions != null) {
                for (int i = 0; i < this.mWaitingRequestPermissions.size(); ++i) {
                    int key = this.mWaitingRequestPermissions.keyAt(i);
                    if (Build.VERSION.SDK_INT < 23) continue;
                    this.requestPermissions((String[])this.mWaitingRequestPermissions.get(key), key);
                }
                this.mWaitingRequestPermissions = null;
            }
            if (this.mWaitingStartActivities != null) {
                for (IntentConfig config : this.mWaitingStartActivities) {
                    this.startActivityForResult(config.intent, config.requestCode, config.options);
                }
                this.mWaitingStartActivities = null;
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            OnPermissionsResultCallback callback;
            if (this.mPermissionsResultCallbacks != null && (callback = (OnPermissionsResultCallback)this.mPermissionsResultCallbacks.get(requestCode)) != null) {
                callback.onPermissionsResult(requestCode, permissions, grantResults);
                this.mPermissionsResultCallbacks.remove(requestCode);
            }
        }

        @RequiresApi(api=23)
        public void requestPermissionsForResult(@NonNull String[] permissions, int requestCode, OnPermissionsResultCallback callback) {
            if (this.mPermissionsResultCallbacks == null) {
                this.mPermissionsResultCallbacks = new SparseArray(1);
            }
            if (callback != null) {
                this.mPermissionsResultCallbacks.put(requestCode, (Object)callback);
            }
            if (this.isAdded()) {
                this.requestPermissions(permissions, requestCode);
            } else {
                if (this.mWaitingRequestPermissions == null) {
                    this.mWaitingRequestPermissions = new SparseArray(1);
                }
                this.mWaitingRequestPermissions.put(requestCode, (Object)permissions);
            }
        }

        public void startActivityForResult(Intent intent, int requestCode, Bundle options, OnActivityResultCallback callback) {
            if (callback != null) {
                this.mCallbackParams.add(new CallbackParams(requestCode, callback));
            }
            if (this.isAdded()) {
                this.startActivityForResult(intent, requestCode, options);
            } else {
                if (this.mWaitingStartActivities == null) {
                    this.mWaitingStartActivities = new ArrayList<IntentConfig>(1);
                }
                this.mWaitingStartActivities.add(new IntentConfig(intent, requestCode, options));
            }
        }

        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            super.onActivityResult(requestCode, resultCode, data);
            int performedIndex = -1;
            for (int i = this.mCallbackParams.size() - 1; i >= 0; --i) {
                CallbackParams callbackParams = this.mCallbackParams.get(i);
                if (callbackParams.requestCode != requestCode) continue;
                callbackParams.callback.onActivityResult(requestCode, resultCode, data);
                performedIndex = i;
                break;
            }
            if (performedIndex > -1) {
                this.mCallbackParams.remove(performedIndex);
            }
        }

        private static class CallbackParams {
            int requestCode;
            OnActivityResultCallback callback;

            public CallbackParams(int requestCode, OnActivityResultCallback callback) {
                this.requestCode = requestCode;
                this.callback = callback;
            }
        }

        private static class IntentConfig {
            Intent intent;
            int requestCode;
            Bundle options;

            public IntentConfig(Intent intent, int requestCode, Bundle options) {
                this.intent = intent;
                this.requestCode = requestCode;
                this.options = options;
            }
        }
    }
}

