/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.SparseArray;
import com.aliya.permission.OpEntity;
import com.aliya.permission.Permission;
import com.aliya.permission.PermissionCallback;
import com.aliya.permission.ResultHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PermissionManager {
    private static final int EMPTY = 0;
    private static volatile PermissionManager mInstance;
    private static Context sContext;
    static boolean sDebuggable;
    private Set<String> mManifestPermissions;
    private final SparseArray<OpEntity> mRequestCaches = new SparseArray();
    private final ResultHelper.OnPermissionsResultCallback mPermissionsResultCallback = new ResultHelper.OnPermissionsResultCallback(){

        @Override
        public void onPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            PermissionManager.onRequestPermissionResult(requestCode, permissions, grantResults);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PermissionManager _get() {
        if (mInstance != null) return mInstance;
        Class<PermissionManager> clazz = PermissionManager.class;
        synchronized (PermissionManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PermissionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private PermissionManager() {
    }

    public static boolean request(Context context, PermissionCallback callback, String ... permissions) {
        return PermissionManager.request(ResultHelper.getActivityByContext(context), callback, permissions);
    }

    public static boolean request(Activity activity, PermissionCallback callback, String ... permissions) {
        return PermissionManager.request(activity, callback, null, permissions);
    }

    public static boolean request(Context activityContext, PermissionCallback callback, Permission ... permissions) {
        return PermissionManager.request(ResultHelper.getActivityByContext(activityContext), callback, permissions);
    }

    public static boolean request(Activity activity, PermissionCallback callback, Permission ... permissions) {
        return PermissionManager.request(activity, callback, permissions, null);
    }

    public static boolean request(Context activityContext, PermissionCallback callback, Permission.Group ... groups) {
        Permission[] permissions = null;
        for (Permission.Group group : groups) {
            Permission[] groupPermissions = group.getGroup();
            if (permissions == null) {
                permissions = groupPermissions;
                continue;
            }
            permissions = Arrays.copyOf(permissions, permissions.length + groupPermissions.length);
            System.arraycopy(groupPermissions, 0, permissions, permissions.length - groupPermissions.length, groupPermissions.length);
        }
        return PermissionManager.request(activityContext, callback, permissions);
    }

    static boolean request(Activity activity, PermissionCallback callback, Permission[] permissions, String[] permissionStrings) {
        PermissionManager.initContext((Context)activity);
        int length = 0;
        if (permissions != null) {
            length += permissions.length;
        }
        if (permissionStrings != null) {
            length += permissionStrings.length;
        }
        if (length == 0) {
            return true;
        }
        if (activity == null) {
            if (sDebuggable) {
                throw new IllegalArgumentException("Activity shouldn't be null.");
            }
            return false;
        }
        OpEntity opEntity = new OpEntity(activity, callback);
        if (permissions != null) {
            for (Permission permission2 : permissions) {
                PermissionManager.assortPermission(opEntity, permission2.getPermission());
            }
        }
        if (permissionStrings != null) {
            for (String string : permissionStrings) {
                PermissionManager.assortPermission(opEntity, string);
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (PermissionManager.equalsSize(opEntity.grantedPermissions, length)) {
                if (callback != null) {
                    callback.onGranted(true);
                }
                return true;
            }
            if (PermissionManager.equalsSize(opEntity.waitPermissions, 0)) {
                if (callback != null) {
                    callback.onDenied(opEntity.deniedPermissions, opEntity.neverAskPermissions);
                }
            } else {
                PermissionManager._get().requestPermission(activity, opEntity);
            }
        } else {
            return PermissionManager.dispatchCallback(opEntity);
        }
        return false;
    }

    static boolean dispatchCallback(OpEntity opEntity) {
        boolean granted = PermissionManager.equalsSize(opEntity.deniedPermissions, 0);
        if (opEntity.callback != null) {
            if (granted) {
                opEntity.callback.onGranted(Build.VERSION.SDK_INT < 23);
            } else {
                opEntity.callback.onDenied(opEntity.deniedPermissions, opEntity.neverAskPermissions);
            }
        }
        return granted;
    }

    static void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        OpEntity opEntity = (OpEntity)PermissionManager._get().mRequestCaches.get(requestCode);
        if (opEntity != null) {
            PermissionManager._get().mRequestCaches.remove(requestCode);
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    opEntity.addGrantedPermission(permissions[i]);
                    continue;
                }
                if (!PermissionManager.shouldShowRequestPermissionRationale((Context)opEntity.getActivity(), permissions[i])) {
                    opEntity.addNeverAskPermission(permissions[i]);
                    continue;
                }
                opEntity.addDeniedPermission(permissions[i]);
            }
            PermissionManager.dispatchCallback(opEntity);
        }
    }

    public static boolean shouldShowRequestPermissionRationale(Context activityContext, @NonNull String permission2) {
        Activity activity;
        if (Build.VERSION.SDK_INT >= 23 && (activity = ResultHelper.getActivityByContext(activityContext)) != null) {
            return activity.shouldShowRequestPermissionRationale(permission2);
        }
        return false;
    }

    static void assortPermission(OpEntity opEntity, String permission2) {
        if (PermissionManager.checkPermission(sContext, permission2)) {
            opEntity.addGrantedPermission(permission2);
        } else if (Build.VERSION.SDK_INT >= 23) {
            opEntity.addWaitPermission(permission2);
        } else {
            opEntity.addNeverAskPermission(permission2);
        }
    }

    public static boolean checkPermission(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPermission(Context context, Permission ... permissions) {
        for (Permission permission2 : permissions) {
            if (context.checkPermission(permission2.getPermission(), Process.myPid(), Process.myUid()) == 0) continue;
            return false;
        }
        return true;
    }

    public static Intent getSettingIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
        return intent;
    }

    static void initContext(Context context) {
        if (sContext == null && context != null) {
            sContext = context.getApplicationContext();
            try {
                sDebuggable = (context.getApplicationInfo().flags & 2) != 0;
            }
            catch (Exception e) {
                sDebuggable = false;
            }
        }
    }

    @RequiresApi(api=23)
    private void requestPermission(Activity activity, OpEntity opEntity) {
        this.mRequestCaches.put(opEntity.requestCode, (Object)opEntity);
        ResultHelper.requestPermissions((Context)activity, opEntity.getWaitPermsArray(), opEntity.requestCode, this.mPermissionsResultCallback);
        opEntity.waitPermissions = null;
    }

    static boolean equalsSize(List list, int size) {
        return (list != null ? list.size() : 0) == size;
    }

    @Deprecated
    private Set<String> getManifestPermissions() {
        String[] permissions;
        HashSet<Object> manifestPermissions = null;
        PackageInfo packageInfo = null;
        try {
            packageInfo = sContext.getPackageManager().getPackageInfo(sContext.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo != null && (permissions = packageInfo.requestedPermissions) != null && permissions.length != 0) {
            manifestPermissions = new HashSet<String>(Arrays.asList(permissions));
        }
        return manifestPermissions != null ? manifestPermissions : new HashSet(0);
    }

    static {
        sDebuggable = false;
    }
}

