/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import com.aliya.permission.PermissionCallback;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class OpEntity
implements Serializable {
    private static int sCode = 0;
    List<String> grantedPermissions;
    List<String> deniedPermissions;
    List<String> neverAskPermissions;
    List<String> waitPermissions;
    PermissionCallback callback;
    private WeakReference<Activity> mActivityWeak;
    int requestCode;

    OpEntity(Activity activity, PermissionCallback callback) {
        this.mActivityWeak = new WeakReference<Activity>(activity);
        this.callback = callback;
        this.requestCode = OpEntity.obtainRequestCode();
    }

    Activity getActivity() {
        return (Activity)this.mActivityWeak.get();
    }

    void addGrantedPermission(String permission) {
        if (this.grantedPermissions == null) {
            this.grantedPermissions = new ArrayList<String>();
        }
        this.grantedPermissions.add(permission);
    }

    void addDeniedPermission(String permission) {
        if (this.deniedPermissions == null) {
            this.deniedPermissions = new ArrayList<String>();
        }
        this.deniedPermissions.add(permission);
    }

    void addNeverAskPermission(String permission) {
        if (this.neverAskPermissions == null) {
            this.neverAskPermissions = new ArrayList<String>();
        }
        this.neverAskPermissions.add(permission);
        this.addDeniedPermission(permission);
    }

    void addWaitPermission(String permission) {
        if (this.waitPermissions == null) {
            this.waitPermissions = new ArrayList<String>();
        }
        this.waitPermissions.add(permission);
    }

    String[] getWaitPermsArray() {
        if (this.waitPermissions != null) {
            return this.waitPermissions.toArray(new String[this.waitPermissions.size()]);
        }
        return null;
    }

    private static int obtainRequestCode() {
        if ((sCode & 0xFFFF0000) != 0) {
            sCode = 0;
        }
        return sCode++;
    }
}

