/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.SparseArray;
import com.aliya.permission.PermissionManager;
import com.aliya.permission.PermissionOperate;

final class RequestHelper {
    private static final String FRAGMENT_TAG = "request_fragment_tag";

    RequestHelper() {
    }

    public static Activity getActivityByContext(Context context) {
        PermissionManager.initContext(context);
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (PermissionManager.sDebuggable) {
            throw new IllegalArgumentException(context + " should be include activity");
        }
        return null;
    }

    public static PermissionOperate getPermissionOperate(Activity activity) {
        RequestPermissionFragment requestFragment;
        FragmentManager manager = activity.getFragmentManager();
        Fragment fragmentByTag = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragmentByTag instanceof PermissionOperate) {
            requestFragment = (RequestPermissionFragment)fragmentByTag;
        } else {
            requestFragment = new RequestPermissionFragment();
            manager.beginTransaction().add((Fragment)requestFragment, FRAGMENT_TAG).commitAllowingStateLoss();
        }
        return requestFragment;
    }

    public static class RequestPermissionFragment
    extends Fragment
    implements PermissionOperate {
        private SparseArray<String[]> mWaitingArray;

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (this.mWaitingArray != null) {
                for (int i = 0; i < this.mWaitingArray.size(); ++i) {
                    int key = this.mWaitingArray.keyAt(i);
                    if (Build.VERSION.SDK_INT < 23) continue;
                    this.requestPermissions((String[])this.mWaitingArray.get(key), key);
                }
                this.mWaitingArray = null;
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            PermissionManager.onRequestPermissionResult(requestCode, permissions, grantResults, this);
        }

        @Override
        @RequiresApi(api=23)
        public void exeRequestPermissions(@NonNull String[] permissions, int requestCode) {
            if (this.getHost() == null) {
                if (this.mWaitingArray == null) {
                    this.mWaitingArray = new SparseArray(1);
                }
                this.mWaitingArray.put(requestCode, (Object)permissions);
            } else {
                this.requestPermissions(permissions, requestCode);
            }
        }

        @Override
        @RequiresApi(api=23)
        public boolean exeShouldShowRequestPermissionRationale(@NonNull String permission2) {
            return this.shouldShowRequestPermissionRationale(permission2);
        }
    }
}

