/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.SparseArray;
import com.aliya.permission.Permission;
import com.aliya.permission.PermissionCallback;
import com.aliya.permission.PermissionOperate;
import com.aliya.permission.RequestHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PermissionManager {
    private static final int EMPTY = 0;
    private static volatile PermissionManager mInstance;
    private static int sCode;
    private static Context sContext;
    static boolean sDebuggable;
    private final SparseArray<OpEntity> mRequestCaches = new SparseArray();
    private final Set<String> mManifestPermissions = this.getManifestPermissions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PermissionManager _get() {
        if (mInstance != null) return mInstance;
        Class<PermissionManager> clazz = PermissionManager.class;
        synchronized (PermissionManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PermissionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private PermissionManager() {
    }

    public static boolean request(Context context, PermissionCallback callback, String ... permissions) {
        return PermissionManager.request(RequestHelper.getActivityByContext(context), callback, permissions);
    }

    public static boolean request(Activity activity, PermissionCallback callback, String ... permissions) {
        return PermissionManager.request(activity, callback, null, permissions);
    }

    public static boolean request(Context context, PermissionCallback callback, Permission ... permissions) {
        return PermissionManager.request(RequestHelper.getActivityByContext(context), callback, permissions);
    }

    public static boolean request(Activity activity, PermissionCallback callback, Permission ... permissions) {
        return PermissionManager.request(activity, callback, permissions, null);
    }

    private static boolean request(Activity activity, PermissionCallback callback, Permission[] permissions, String[] permissionArray) {
        PermissionManager.initContext((Context)activity);
        int length = 0;
        if (permissions != null) {
            length += permissions.length;
        }
        if (permissionArray != null) {
            length += permissionArray.length;
        }
        if (length == 0 || activity == null) {
            if (activity == null && sDebuggable) {
                throw new IllegalArgumentException("activity shouldn't be null.");
            }
            return false;
        }
        OpEntity opEntity = new OpEntity(callback);
        if (Build.VERSION.SDK_INT >= 23) {
            if (permissions != null) {
                for (Permission permission2 : permissions) {
                    PermissionManager.assortPermission(opEntity, permission2.getPermission());
                }
            }
            if (permissionArray != null) {
                for (String string : permissionArray) {
                    PermissionManager.assortPermission(opEntity, string);
                }
            }
            if (OpEntity.equalsSize(opEntity.grantedPermissions, length)) {
                if (callback != null) {
                    callback.onGranted(true);
                }
                return true;
            }
            if (OpEntity.equalsSize(opEntity.waitPermissions, 0)) {
                if (callback != null) {
                    if (OpEntity.equalsSize(opEntity.grantedPermissions, 0)) {
                        callback.onDenied(opEntity.neverAskPermissions);
                    } else {
                        callback.onElse(opEntity.deniedPermissions, opEntity.neverAskPermissions);
                    }
                }
            } else {
                PermissionManager._get().requestPermission(activity, opEntity);
            }
        } else {
            if (callback != null) {
                callback.onGranted(true);
            }
            return true;
        }
        return false;
    }

    static void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults, PermissionOperate showRationale) {
        OpEntity opEntity = (OpEntity)PermissionManager._get().mRequestCaches.get(requestCode);
        if (opEntity != null) {
            PermissionManager._get().mRequestCaches.remove(requestCode);
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    opEntity.addGrantedPermission(permissions[i]);
                    continue;
                }
                if (!showRationale.exeShouldShowRequestPermissionRationale(permissions[i])) {
                    opEntity.addNeverAskPermission(permissions[i]);
                    continue;
                }
                opEntity.addDeniedPermission(permissions[i]);
            }
            if (opEntity.callback == null) {
                return;
            }
            if (OpEntity.equalsSize(opEntity.deniedPermissions, 0)) {
                opEntity.callback.onGranted(false);
            } else if (OpEntity.equalsSize(opEntity.grantedPermissions, 0)) {
                opEntity.callback.onDenied(opEntity.neverAskPermissions);
            } else {
                opEntity.callback.onElse(opEntity.deniedPermissions, opEntity.neverAskPermissions);
            }
        }
    }

    public static boolean shouldShowRequestPermissionRationale(Context context, @NonNull String permission2) {
        Activity activity;
        PermissionManager.initContext(context);
        if (Build.VERSION.SDK_INT >= 23 && (activity = RequestHelper.getActivityByContext(context)) != null) {
            return activity.shouldShowRequestPermissionRationale(permission2);
        }
        return false;
    }

    static void assortPermission(OpEntity opEntity, String permission2) {
        if (PermissionManager._get().mManifestPermissions.contains(permission2)) {
            if (PermissionManager.checkPermission(sContext, permission2)) {
                opEntity.addGrantedPermission(permission2);
            } else {
                opEntity.addWaitPermission(permission2);
            }
        } else {
            opEntity.addNeverAskPermission(permission2);
        }
    }

    public static boolean checkPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        return true;
    }

    public static Intent getSettingIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
        return intent;
    }

    static void initContext(Context context) {
        if (sContext == null && context != null) {
            sContext = context.getApplicationContext();
            try {
                sDebuggable = (context.getApplicationInfo().flags & 2) != 0;
            }
            catch (Exception e) {
                sDebuggable = false;
            }
        }
    }

    private Set<String> getManifestPermissions() {
        String[] permissions;
        HashSet<Object> manifestPermissions = null;
        PackageInfo packageInfo = null;
        try {
            packageInfo = sContext.getPackageManager().getPackageInfo(sContext.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo != null && (permissions = packageInfo.requestedPermissions) != null && permissions.length != 0) {
            manifestPermissions = new HashSet<String>(Arrays.asList(permissions));
        }
        return manifestPermissions != null ? manifestPermissions : new HashSet(0);
    }

    private void requestPermission(Activity activity, OpEntity opEntity) {
        this.mRequestCaches.put(opEntity.requestCode, (Object)opEntity);
        PermissionOperate operate = RequestHelper.getPermissionOperate(activity);
        operate.exeRequestPermissions(opEntity.getWaitPermsArray(), opEntity.requestCode);
        opEntity.waitPermissions = null;
    }

    private static int obtainRequestCode() {
        if ((sCode & 0xFFFF0000) != 0) {
            sCode = 0;
        }
        return sCode++;
    }

    static {
        sCode = 0;
        sDebuggable = false;
    }

    static class OpEntity
    implements Serializable {
        List<String> grantedPermissions;
        List<String> deniedPermissions;
        List<String> neverAskPermissions;
        List<String> waitPermissions;
        PermissionCallback callback;
        int requestCode;

        OpEntity(PermissionCallback callback) {
            this.callback = callback;
            this.requestCode = PermissionManager.obtainRequestCode();
        }

        void addGrantedPermission(String permission2) {
            if (this.grantedPermissions == null) {
                this.grantedPermissions = new ArrayList<String>();
            }
            this.grantedPermissions.add(permission2);
        }

        void addDeniedPermission(String permission2) {
            if (this.deniedPermissions == null) {
                this.deniedPermissions = new ArrayList<String>();
            }
            this.deniedPermissions.add(permission2);
        }

        void addNeverAskPermission(String permission2) {
            if (this.neverAskPermissions == null) {
                this.neverAskPermissions = new ArrayList<String>();
            }
            this.neverAskPermissions.add(permission2);
            this.addDeniedPermission(permission2);
        }

        void addWaitPermission(String permission2) {
            if (this.waitPermissions == null) {
                this.waitPermissions = new ArrayList<String>();
            }
            this.waitPermissions.add(permission2);
        }

        String[] getWaitPermsArray() {
            if (this.waitPermissions != null) {
                return this.waitPermissions.toArray(new String[this.waitPermissions.size()]);
            }
            return null;
        }

        public static boolean equalsSize(List list, int size) {
            return (list != null ? list.size() : 0) == size;
        }
    }
}

