/*
 * Decompiled with CFR 0.152.
 */
package com.aliya.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.SparseArray;
import com.aliya.permission.Permission;
import com.aliya.permission.PermissionCallback;
import com.aliya.permission.PermissionOperate;
import com.aliya.permission.RequestHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PermissionManager {
    private static final int EMPTY = 0;
    private static volatile PermissionManager mInstance;
    private static Context sContext;
    private final SparseArray<OpEntity> mRequestCaches = new SparseArray();
    private final Set<String> mManifestPermissions = this.getManifestPermissions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PermissionManager _get() {
        if (mInstance != null) return mInstance;
        Class<PermissionManager> clazz = PermissionManager.class;
        synchronized (PermissionManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PermissionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private PermissionManager() {
    }

    public static boolean request(Context context, PermissionCallback callback, Permission ... permissions) {
        return PermissionManager.request(RequestHelper.getActivityByContext(context), callback, permissions);
    }

    public static boolean request(Activity activity, PermissionCallback callback, Permission ... permissions) {
        PermissionManager.initContext((Context)activity);
        if (permissions == null || permissions.length == 0) {
            return true;
        }
        if (activity == null || callback == null) {
            return false;
        }
        OpEntity opEntity = new OpEntity(callback);
        if (Build.VERSION.SDK_INT >= 23) {
            for (Permission permission2 : permissions) {
                if (PermissionManager._get().mManifestPermissions.contains(permission2.getPermission())) {
                    if (PermissionManager.checkPermission(permission2.getPermission())) {
                        opEntity.addGrantedPermission(permission2.getPermission());
                        continue;
                    }
                    opEntity.addWaitPermission(permission2.getPermission());
                    continue;
                }
                opEntity.addNeverAskPermission(permission2.getPermission());
            }
            if (OpEntity.equalsSize(opEntity.grantedPermissions, permissions.length)) {
                callback.onGranted(true);
                return true;
            }
            if (OpEntity.equalsSize(opEntity.waitPermissions, 0)) {
                if (OpEntity.equalsSize(opEntity.grantedPermissions, 0)) {
                    callback.onDenied(opEntity.neverAskPermissions);
                } else {
                    callback.onElse(opEntity.deniedPermissions, opEntity.neverAskPermissions);
                }
            } else {
                PermissionManager._get().requestPermission(activity, opEntity);
            }
        } else {
            callback.onGranted(true);
            return true;
        }
        return false;
    }

    static void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults, PermissionOperate showRationale) {
        OpEntity opEntity = (OpEntity)PermissionManager._get().mRequestCaches.get(requestCode);
        if (opEntity != null) {
            PermissionManager._get().mRequestCaches.remove(requestCode);
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    opEntity.addGrantedPermission(permissions[i]);
                    continue;
                }
                if (!showRationale.exeShouldShowRequestPermissionRationale(permissions[i])) {
                    opEntity.addNeverAskPermission(permissions[i]);
                    continue;
                }
                opEntity.addDeniedPermission(permissions[i]);
            }
            if (opEntity.callback == null) {
                return;
            }
            if (OpEntity.equalsSize(opEntity.deniedPermissions, 0)) {
                opEntity.callback.onGranted(false);
            } else if (OpEntity.equalsSize(opEntity.grantedPermissions, 0)) {
                opEntity.callback.onDenied(opEntity.neverAskPermissions);
            } else {
                opEntity.callback.onElse(opEntity.deniedPermissions, opEntity.neverAskPermissions);
            }
        }
    }

    static boolean checkPermission(String permission2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ContextCompat.checkSelfPermission((Context)sContext, (String)permission2) == 0;
        }
        return true;
    }

    public static void startSettingIntent() {
        if (sContext != null) {
            Intent setting = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            setting.setData(Uri.parse((String)("package:" + sContext.getPackageName())));
            setting.setFlags(0x10000000);
            sContext.startActivity(setting);
        }
    }

    private static void initContext(Context context) {
        if (sContext == null && context != null) {
            sContext = context.getApplicationContext();
        }
    }

    private Set<String> getManifestPermissions() {
        String[] permissions;
        HashSet<Object> manifestPermissions = null;
        PackageInfo packageInfo = null;
        try {
            packageInfo = sContext.getPackageManager().getPackageInfo(sContext.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageInfo != null && (permissions = packageInfo.requestedPermissions) != null && permissions.length != 0) {
            manifestPermissions = new HashSet<String>(Arrays.asList(permissions));
        }
        return manifestPermissions != null ? manifestPermissions : new HashSet(0);
    }

    private void requestPermission(Activity activity, OpEntity opEntity) {
        this.mRequestCaches.put(opEntity.requestCode, (Object)opEntity);
        PermissionOperate operate = RequestHelper.getPermissionOperate(activity);
        operate.exeRequestPermissions(opEntity.getWaitPermsArray(), opEntity.requestCode);
        opEntity.waitPermissions = null;
    }

    static class OpEntity
    implements Serializable {
        List<String> grantedPermissions;
        List<String> deniedPermissions;
        List<String> neverAskPermissions;
        List<String> waitPermissions;
        PermissionCallback callback;
        int requestCode;
        static int count = 0;

        OpEntity(PermissionCallback callback) {
            this.callback = callback;
            this.requestCode = count++;
            if ((count & 0xFFFF0000) != 0) {
                count = 0;
            }
        }

        void addGrantedPermission(String permission2) {
            if (this.grantedPermissions == null) {
                this.grantedPermissions = new ArrayList<String>();
            }
            this.grantedPermissions.add(permission2);
        }

        void addDeniedPermission(String permission2) {
            if (this.deniedPermissions == null) {
                this.deniedPermissions = new ArrayList<String>();
            }
            this.deniedPermissions.add(permission2);
        }

        void addNeverAskPermission(String permission2) {
            if (this.neverAskPermissions == null) {
                this.neverAskPermissions = new ArrayList<String>();
            }
            this.neverAskPermissions.add(permission2);
            this.addDeniedPermission(permission2);
        }

        void addWaitPermission(String permission2) {
            if (this.waitPermissions == null) {
                this.waitPermissions = new ArrayList<String>();
            }
            this.waitPermissions.add(permission2);
        }

        String[] getWaitPermsArray() {
            if (this.waitPermissions != null) {
                return this.waitPermissions.toArray(new String[this.waitPermissions.size()]);
            }
            return null;
        }

        public static boolean equalsSize(List list, int size) {
            return (list != null ? list.size() : 0) == size;
        }
    }
}

