/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.util;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.util.CoolDown;
import com.alipay.common.tracer.util.Desensitizer;
import java.util.ServiceLoader;

public class DesensitizationHelper {
    public static final String ENABLED_KEY = "tracer_desens_enabled";
    public static final String ENABLED_DEFAULT_VALUE = "false";
    private static final CoolDown COOL_DOWN = new CoolDown(60000L, 10);
    static volatile Desensitizer desensitizer;

    public static void setDesensitizer(Desensitizer desensitizer) {
        DesensitizationHelper.desensitizer = desensitizer;
    }

    public static String desensitize(String str) {
        if (!DesensitizationHelper.enabled()) {
            return str;
        }
        Desensitizer desensitizer = DesensitizationHelper.desensitizer;
        if (desensitizer == null) {
            return str;
        }
        try {
            return desensitizer.desensitize(str);
        }
        catch (Throwable e) {
            if (COOL_DOWN.tryAcquire()) {
                SelfLog.error("fail to desensitize: " + str, e);
            }
            return str;
        }
    }

    private static boolean enabled() {
        return desensitizer != null && "true".equals(SofaTracerConfiguration.getProperty(ENABLED_KEY, ENABLED_DEFAULT_VALUE));
    }

    static {
        try {
            ServiceLoader<Desensitizer> loader = ServiceLoader.load(Desensitizer.class, DesensitizationHelper.class.getClassLoader());
            Desensitizer first = null;
            for (Desensitizer d : loader) {
                if (first == null) {
                    first = d;
                }
                String msg = String.format("Find Desensitizer impl: %s %s", d.getClass(), d.toString());
                SelfLog.info(msg);
            }
            desensitizer = first;
        }
        catch (Throwable e) {
            SelfLog.warn("Fail to find class ScanAndDesensUtil, desensitization is disabled", e);
        }
    }
}

