/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.util;

import java.util.concurrent.atomic.AtomicInteger;

class CoolDown {
    final long intervalMills;
    final int times;
    final AtomicInteger counter = new AtomicInteger(0);
    final AtomicInteger wip = new AtomicInteger(0);
    volatile long nextResetTime;

    CoolDown(long resetIntervalMills, int times) {
        this.intervalMills = resetIntervalMills;
        this.times = times;
        this.nextResetTime = System.currentTimeMillis() + resetIntervalMills;
    }

    boolean tryAcquire() {
        while (true) {
            int c;
            if ((c = this.counter.get()) < this.times) {
                if (!this.counter.compareAndSet(c, c + 1)) continue;
                return true;
            }
            long now = System.currentTimeMillis();
            if (now <= this.nextResetTime) break;
            if (!this.wip.compareAndSet(0, 1)) continue;
            if (now > this.nextResetTime) {
                this.nextResetTime = now + this.intervalMills;
                this.counter.set(0);
            }
            this.wip.set(0);
        }
        return false;
    }
}

