/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.span;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.extensions.SpanExtensionFactory;
import com.alipay.common.tracer.core.reporter.common.CommonTracerManager;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.span.CommonLogSpan;
import com.alipay.common.tracer.core.span.LogData;
import com.alipay.common.tracer.core.span.SofaTracerSpanReferenceRelationship;
import com.alipay.common.tracer.core.tags.SpanTags;
import com.alipay.common.tracer.core.utils.AssertUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.common.code.LogCode2Description;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SofaTracerSpan
implements Span {
    public static final char ARRAY_SEPARATOR = '|';
    private final SofaTracer sofaTracer;
    private final List<SofaTracerSpanReferenceRelationship> spanReferences;
    private final Map<String, String> tagsWithStr = new LinkedHashMap<String, String>();
    private final Map<String, Boolean> tagsWithBool = new LinkedHashMap<String, Boolean>();
    private final Map<String, Number> tagsWithNumber = new LinkedHashMap<String, Number>();
    private final List<LogData> logs = new LinkedList<LogData>();
    private String operationName = "";
    private final SofaTracerSpanContext sofaTracerSpanContext;
    private long startTime;
    private long endTime = -1L;
    private String logType = "";
    private SofaTracerSpan parentSofaTracerSpan = null;

    public SofaTracerSpan cloneInstance() {
        SofaTracerSpanContext spanContext = this.sofaTracerSpanContext.cloneInstance();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.putAll(this.tagsWithBool);
        tags.putAll(this.tagsWithStr);
        tags.putAll(this.tagsWithNumber);
        SofaTracerSpan cloneSpan = new SofaTracerSpan(this.sofaTracer, this.startTime, this.spanReferences, this.operationName, spanContext, tags);
        if (this.logs != null && this.logs.size() > 0) {
            for (LogData logData : this.logs) {
                cloneSpan.log(logData);
            }
        }
        cloneSpan.setEndTime(this.endTime);
        cloneSpan.setLogType(this.logType);
        cloneSpan.setParentSofaTracerSpan(this.parentSofaTracerSpan);
        return cloneSpan;
    }

    public SofaTracerSpan(SofaTracer sofaTracer, long startTime, String operationName, SofaTracerSpanContext sofaTracerSpanContext, Map<String, ?> tags) {
        this(sofaTracer, startTime, null, operationName, sofaTracerSpanContext != null ? sofaTracerSpanContext : SofaTracerSpanContext.rootStart(), tags);
    }

    public SofaTracerSpan(SofaTracer sofaTracer, long startTime, List<SofaTracerSpanReferenceRelationship> spanReferences, String operationName, SofaTracerSpanContext sofaTracerSpanContext, Map<String, ?> tags) {
        AssertUtils.notNull(sofaTracer);
        AssertUtils.notNull(sofaTracerSpanContext);
        this.sofaTracer = sofaTracer;
        this.startTime = startTime;
        this.spanReferences = spanReferences != null ? new ArrayList<SofaTracerSpanReferenceRelationship>(spanReferences) : null;
        this.operationName = operationName;
        this.sofaTracerSpanContext = sofaTracerSpanContext;
        this.setTags(tags);
        SpanExtensionFactory.logStartedSpan(this);
    }

    public SpanContext context() {
        return this.sofaTracerSpanContext;
    }

    public void finish() {
        this.finish(System.currentTimeMillis());
    }

    public void finish(long endTime) {
        this.setEndTime(endTime);
        this.sofaTracer.reportSpan(this);
        SpanExtensionFactory.logStoppedSpan(this);
    }

    public void close() {
        this.finish();
    }

    public Span setTag(String key, String value) {
        Reporter clientReporter;
        if (StringUtils.isBlank(key) || StringUtils.isBlank(value)) {
            return this;
        }
        this.tagsWithStr.put(key, value);
        if (this.isServer()) {
            Reporter serverReporter = this.sofaTracer.getServerReporter();
            if (serverReporter != null) {
                this.setLogType(serverReporter.getReporterType());
            }
        } else if (this.isClient() && (clientReporter = this.sofaTracer.getClientReporter()) != null) {
            this.setLogType(clientReporter.getReporterType());
        }
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.tagsWithBool.put(key, value);
        return this;
    }

    public Span setTag(String key, Number number) {
        if (number == null) {
            return this;
        }
        this.tagsWithNumber.put(key, number);
        return this;
    }

    public Span log(String eventValue) {
        return this.log(System.currentTimeMillis(), eventValue);
    }

    public Span log(long currentTime, String eventValue) {
        AssertUtils.isTrue(currentTime >= this.startTime, "Current time must greater than start time");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("event", eventValue);
        return this.log(currentTime, fields);
    }

    public Span log(LogData logData) {
        if (logData == null) {
            return this;
        }
        this.logs.add(logData);
        return this;
    }

    public Span log(long currentTime, Map<String, ?> map) {
        AssertUtils.isTrue(currentTime >= this.startTime, "current time must greater than start time");
        this.logs.add(new LogData(currentTime, map));
        return this;
    }

    public Span log(Map<String, ?> map) {
        return this.log(System.currentTimeMillis(), map);
    }

    public Span log(String eventName, Object payload) {
        return this.log(System.currentTimeMillis(), eventName, payload);
    }

    public Span log(long currentTime, String eventName, Object payload) {
        AssertUtils.isTrue(currentTime >= this.startTime, "current time must greater than start time");
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(eventName, payload);
        return this.log(currentTime, fields);
    }

    public Span setBaggageItem(String key, String value) {
        this.sofaTracerSpanContext.setBizBaggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.sofaTracerSpanContext.getBizBaggageItem(key);
    }

    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public void reportError(String errorType, Map<String, String> context, Throwable e, String errorSourceApp, String ... errorSources) {
        Tags.ERROR.set((Span)this, Boolean.valueOf(true));
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.putAll(this.getTagsWithStr());
        tags.putAll(this.getTagsWithBool());
        tags.putAll(this.getTagsWithNumber());
        tags.put(SpanTags.CURR_APP_TAG.getKey(), errorSourceApp);
        CommonLogSpan commonLogSpan = new CommonLogSpan(this.sofaTracer, System.currentTimeMillis(), this.getOperationName(), this.getSofaTracerSpanContext(), tags);
        commonLogSpan.addSlot(Thread.currentThread().getName());
        commonLogSpan.addSlot(errorType);
        commonLogSpan.addSlot(StringUtils.arrayToString(errorSources, '|', "", ""));
        commonLogSpan.addSlot(StringUtils.mapToString(context));
        commonLogSpan.addSlot(this.getSofaTracerSpanContext() == null ? "" : this.getSofaTracerSpanContext().getBizSerializedBaggage());
        if (e == null) {
            commonLogSpan.addSlot("");
        } else {
            StringWriter sw = new StringWriter(256);
            e.printStackTrace(new PrintWriter(sw));
            String exception = sw.getBuffer().toString();
            commonLogSpan.addSlot(exception);
        }
        CommonTracerManager.reportError(commonLogSpan);
    }

    public void profile(String profileApp, String protocolType, String profileMessage) {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.putAll(this.getTagsWithStr());
        tags.putAll(this.getTagsWithBool());
        tags.putAll(this.getTagsWithNumber());
        tags.put(SpanTags.CURR_APP_TAG.getKey(), profileApp);
        CommonLogSpan commonLogSpan = new CommonLogSpan(this.sofaTracer, System.currentTimeMillis(), this.getOperationName(), this.getSofaTracerSpanContext(), tags);
        commonLogSpan.addSlot(protocolType);
        commonLogSpan.addSlot(profileMessage);
        CommonTracerManager.reportProfile(commonLogSpan);
    }

    public SofaTracerSpan getThisAsParentWhenExceedLayer() {
        SofaTracerSpan parent;
        String rpcId = this.sofaTracerSpanContext.getSpanId();
        if (StringUtils.countMatches(rpcId, '.') + 1 > 100) {
            SofaTracerSpanContext parentSpanContext = SofaTracerSpanContext.rootStart();
            HashMap<String, String> baggage = new HashMap<String, String>();
            baggage.putAll(this.sofaTracerSpanContext.getBizBaggage());
            parentSpanContext.addBizBaggage(baggage);
            parent = new SofaTracerSpan(this.sofaTracer, System.currentTimeMillis(), this.operationName, parentSpanContext, null);
            SelfLog.errorWithTraceId("OpenTracing Span layer exceed max layer limit 100", this.sofaTracerSpanContext.getTraceId());
        } else {
            parent = this;
        }
        return parent;
    }

    public List<SofaTracerSpanReferenceRelationship> getSpanReferences() {
        if (this.spanReferences == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.spanReferences);
    }

    public SofaTracer getSofaTracer() {
        return this.sofaTracer;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getDurationMicroseconds() {
        return this.endTime - this.startTime;
    }

    public Map<String, String> getTagsWithStr() {
        return this.tagsWithStr;
    }

    public Map<String, Boolean> getTagsWithBool() {
        return this.tagsWithBool;
    }

    public Map<String, Number> getTagsWithNumber() {
        return this.tagsWithNumber;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public SofaTracerSpanContext getSofaTracerSpanContext() {
        return this.sofaTracerSpanContext;
    }

    public List<LogData> getLogs() {
        return this.logs;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public SofaTracerSpan getParentSofaTracerSpan() {
        if (this.parentSofaTracerSpan != null) {
            return this.parentSofaTracerSpan.getThisAsParentWhenExceedLayer();
        }
        return null;
    }

    public void setParentSofaTracerSpan(SofaTracerSpan parentSofaTracerSpan) {
        this.parentSofaTracerSpan = parentSofaTracerSpan;
    }

    public boolean isServer() {
        return "server".equals(this.tagsWithStr.get(Tags.SPAN_KIND.getKey()));
    }

    public boolean isClient() {
        return "client".equals(this.tagsWithStr.get(Tags.SPAN_KIND.getKey()));
    }

    private void setTags(Map<String, ?> tags) {
        if (tags == null || tags.size() <= 0) {
            return;
        }
        for (Map.Entry<String, ?> entry : tags.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.isBlank(key) || (value = entry.getValue()) == null) continue;
            if (value instanceof String) {
                this.setTag(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                this.setTag(key, (Boolean)value);
                continue;
            }
            if (value instanceof Number) {
                this.setTag(key, (Number)value);
                continue;
            }
            SelfLog.error(String.format(LogCode2Description.convert((String)"sofa-tracer", (String)"01-00012"), value.getClass()));
        }
    }

    public String toString() {
        return "SofaTracerSpan{operationName='" + this.operationName + '\'' + ", sofaTracerSpanContext=" + this.sofaTracerSpanContext + '}';
    }
}

