/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.stat.manager;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatValues;
import com.alipay.common.tracer.core.utils.DateUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SofaTracerStatisticReporterManager {
    public static int CLEAR_STAT_KEY_THRESHOLD = 5000;
    public static final long DEFAULT_CYCLE_SECONDS = 60L;
    static final AtomicInteger THREAD_NUMBER = new AtomicInteger(0);
    private Map<String, SofaTracerStatisticReporter> statReporters = new ConcurrentHashMap<String, SofaTracerStatisticReporter>();
    private long cycleTime;
    private ScheduledExecutorService executor;

    SofaTracerStatisticReporterManager() {
        this(60L);
    }

    SofaTracerStatisticReporterManager(final long cycleTime) {
        this.cycleTime = cycleTime;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Tracer-TimedAppender-" + THREAD_NUMBER.incrementAndGet() + "-" + cycleTime);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.start();
    }

    private void start() {
        long initialDelay = 0L;
        if ("true".equals(SofaTracerConfiguration.getProperty("fill_minute_switch"))) {
            initialDelay = DateUtils.diffNextMinute(new Date());
        }
        this.executor.scheduleAtFixedRate(new StatReporterPrinter(), initialDelay, this.cycleTime * 1000L, TimeUnit.MILLISECONDS);
    }

    public SofaTracerStatisticReporter getStatTracer(String statTracerName) {
        if (StringUtils.isBlank(statTracerName)) {
            return null;
        }
        return this.statReporters.get(statTracerName);
    }

    public synchronized void addStatReporter(SofaTracerStatisticReporter statisticReporter) {
        if (statisticReporter == null) {
            return;
        }
        String statTracerName = statisticReporter.getStatTracerName();
        if (this.statReporters.containsKey(statTracerName)) {
            return;
        }
        this.statReporters.put(statTracerName, statisticReporter);
    }

    public Map<String, SofaTracerStatisticReporter> getStatReporters() {
        return this.statReporters;
    }

    class StatReporterPrinter
    implements Runnable {
        StatReporterPrinter() {
        }

        @Override
        public void run() {
            block5: {
                SofaTracerStatisticReporter st = null;
                try {
                    for (SofaTracerStatisticReporter statTracer : SofaTracerStatisticReporterManager.this.statReporters.values()) {
                        if (!statTracer.shouldPrintNow()) continue;
                        st = statTracer;
                        Map<StatKey, StatValues> statDatas = statTracer.shiftCurrentIndex();
                        for (Map.Entry<StatKey, StatValues> e : statDatas.entrySet()) {
                            StatKey statKeys = e.getKey();
                            StatValues values = e.getValue();
                            long[] tobePrint = values.getCurrentValue();
                            if (tobePrint[0] > 0L) {
                                statTracer.print(statKeys, tobePrint);
                            }
                            values.clear(tobePrint);
                        }
                        if (statDatas.size() <= CLEAR_STAT_KEY_THRESHOLD) continue;
                        statDatas.clear();
                    }
                }
                catch (Throwable t) {
                    if (st == null) break block5;
                    SelfLog.error("Stat log <" + st.getStatTracerName() + "> flush failure.", t);
                }
            }
        }
    }
}

