/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.registry;

import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.RegistryExtractorInjector;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.propagation.TextMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractTextB3Formatter
implements RegistryExtractorInjector<TextMap> {
    public static final String TRACE_ID_KEY_HEAD = "X-B3-TraceId";
    public static final String SPAN_ID_KEY_HEAD = "X-B3-SpanId";
    public static final String PARENT_SPAN_ID_KEY_HEAD = "X-B3-ParentSpanId";
    public static final String SAMPLED_KEY_HEAD = "X-B3-Sampled";
    static final String FLAGS_KEY_HEAD = "X-B3-Flags";
    static final String BAGGAGE_KEY_PREFIX = "baggage-";
    static final String BAGGAGE_SYS_KEY_PREFIX = "baggage-sys-";

    @Override
    public SofaTracerSpanContext extract(TextMap carrier) {
        if (carrier == null) {
            return SofaTracerSpanContext.rootStart();
        }
        String traceId = null;
        String spanId = null;
        String parentId = null;
        boolean sampled = true;
        boolean isGetSampled = false;
        ConcurrentHashMap<String, String> sysBaggage = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> bizBaggage = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : carrier) {
            String valueTmp;
            String keyTmp;
            String key = (String)entry.getKey();
            if (StringUtils.isBlank(key)) continue;
            if (traceId == null && TRACE_ID_KEY_HEAD.equalsIgnoreCase(key)) {
                traceId = this.decodedValue((String)entry.getValue());
            }
            if (spanId == null && SPAN_ID_KEY_HEAD.equalsIgnoreCase(key)) {
                spanId = this.decodedValue((String)entry.getValue());
            }
            if (parentId == null && PARENT_SPAN_ID_KEY_HEAD.equalsIgnoreCase(key)) {
                parentId = this.decodedValue((String)entry.getValue());
            }
            if (!isGetSampled && SAMPLED_KEY_HEAD.equalsIgnoreCase(key)) {
                String valueTmp2 = this.decodedValue((String)entry.getValue());
                sampled = "1".equals(valueTmp2) ? true : ("0".equals(valueTmp2) ? false : Boolean.parseBoolean(valueTmp2));
                isGetSampled = true;
            }
            if (key.indexOf(BAGGAGE_SYS_KEY_PREFIX) == 0) {
                keyTmp = StringUtils.unescapeEqualAndPercent(key).substring(BAGGAGE_SYS_KEY_PREFIX.length());
                valueTmp = StringUtils.unescapeEqualAndPercent(this.decodedValue((String)entry.getValue()));
                sysBaggage.put(keyTmp, valueTmp);
            }
            if (key.indexOf(BAGGAGE_KEY_PREFIX) != 0) continue;
            keyTmp = StringUtils.unescapeEqualAndPercent(key).substring(BAGGAGE_KEY_PREFIX.length());
            valueTmp = StringUtils.unescapeEqualAndPercent(this.decodedValue((String)entry.getValue()));
            bizBaggage.put(keyTmp, valueTmp);
        }
        if (traceId == null) {
            return SofaTracerSpanContext.rootStart();
        }
        if (spanId == null) {
            spanId = "0";
        }
        if (parentId == null) {
            parentId = "";
        }
        SofaTracerSpanContext sofaTracerSpanContext = new SofaTracerSpanContext(traceId, spanId, parentId, sampled);
        if (sysBaggage.size() > 0) {
            sofaTracerSpanContext.addSysBaggage(sysBaggage);
        }
        if (bizBaggage.size() > 0) {
            sofaTracerSpanContext.addBizBaggage(bizBaggage);
        }
        return sofaTracerSpanContext;
    }

    @Override
    public void inject(SofaTracerSpanContext spanContext, TextMap carrier) {
        String value;
        String key;
        if (carrier == null || spanContext == null) {
            return;
        }
        carrier.put(TRACE_ID_KEY_HEAD, this.encodedValue(spanContext.getTraceId()));
        carrier.put(SPAN_ID_KEY_HEAD, this.encodedValue(spanContext.getSpanId()));
        carrier.put(PARENT_SPAN_ID_KEY_HEAD, this.encodedValue(spanContext.getParentId()));
        carrier.put(SPAN_ID_KEY_HEAD, this.encodedValue(spanContext.getSpanId()));
        carrier.put(SAMPLED_KEY_HEAD, this.encodedValue(String.valueOf(spanContext.isSampled())));
        for (Map.Entry<String, String> entry : spanContext.getSysBaggage().entrySet()) {
            key = BAGGAGE_SYS_KEY_PREFIX + StringUtils.escapePercentEqualAnd(entry.getKey());
            value = this.encodedValue(StringUtils.escapePercentEqualAnd(entry.getValue()));
            carrier.put(key, value);
        }
        for (Map.Entry<String, String> entry : spanContext.getBizBaggage().entrySet()) {
            key = BAGGAGE_KEY_PREFIX + StringUtils.escapePercentEqualAnd(entry.getKey());
            value = this.encodedValue(StringUtils.escapePercentEqualAnd(entry.getValue()));
            carrier.put(key, value);
        }
    }

    protected abstract String encodedValue(String var1);

    protected abstract String decodedValue(String var1);
}

