/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.context.span;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.generator.TraceIdGenerator;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.common.tracer.core.utils.TracerUtils;
import io.opentracing.SpanContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SofaTracerSpanContext
implements SpanContext {
    public static final String RPC_ID_SEPARATOR = ".";
    private static final String TRACE_ID_KET = "tcid";
    private static final String SPAN_ID_KET = "spid";
    private static final String PARENT_SPAN_ID_KET = "pspid";
    private static final String SAMPLE_KET = "sample";
    private static final String SYS_BAGGAGE_PREFIX_KEY = "_sys_";
    private String traceId = "";
    private String spanId = "";
    private String parentId = "";
    private boolean isSampled = true;
    private final Map<String, String> sysBaggage = new ConcurrentHashMap<String, String>();
    private final Map<String, String> bizBaggage = new ConcurrentHashMap<String, String>();
    private AtomicInteger childContextIndex = new AtomicInteger(0);

    public SofaTracerSpanContext cloneInstance() {
        SofaTracerSpanContext spanContext = new SofaTracerSpanContext(this.traceId, this.spanId, this.parentId, this.isSampled);
        spanContext.addSysBaggage(this.sysBaggage);
        spanContext.addBizBaggage(this.bizBaggage);
        spanContext.childContextIndex = this.childContextIndex;
        return spanContext;
    }

    public SofaTracerSpanContext() {
        this("", "", null, true);
    }

    public SofaTracerSpanContext(String traceId, String spanId) {
        this(traceId, spanId, null, true);
    }

    public SofaTracerSpanContext(String traceId, String spanId, String parentId) {
        this(traceId, spanId, parentId, true);
    }

    public SofaTracerSpanContext(String traceId, String spanId, String parentId, boolean isSampled) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = StringUtils.isBlank(parentId) ? this.genParentSpanId(spanId) : parentId;
        this.isSampled = isSampled;
    }

    public SofaTracerSpanContext addBizBaggage(Map<String, String> bizBaggage) {
        if (bizBaggage != null && bizBaggage.size() > 0) {
            this.bizBaggage.putAll(bizBaggage);
        }
        return this;
    }

    public SofaTracerSpanContext addSysBaggage(Map<String, String> sysBaggage) {
        if (sysBaggage != null && sysBaggage.size() > 0) {
            this.sysBaggage.putAll(sysBaggage);
        }
        return this;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        HashMap<String, String> allBaggage = new HashMap<String, String>();
        if (this.bizBaggage != null && this.bizBaggage.size() > 0) {
            allBaggage.putAll(this.bizBaggage);
        }
        if (this.sysBaggage != null && this.sysBaggage.size() > 0) {
            allBaggage.putAll(this.sysBaggage);
        }
        return allBaggage.entrySet();
    }

    private String contextAsString() {
        return String.format("%s:%s:%s:%s", this.traceId, this.spanId, this.parentId, this.isSampled);
    }

    public String getBizSerializedBaggage() {
        return StringUtils.mapToString(this.bizBaggage);
    }

    public String getSysSerializedBaggage() {
        return StringUtils.mapToString(this.sysBaggage);
    }

    public void deserializeBizBaggage(String bizBaggageAttrs) {
        StringUtils.stringToMap(bizBaggageAttrs, this.bizBaggage);
        if (StringUtils.isNotBlank(bizBaggageAttrs) && bizBaggageAttrs.length() > TracerUtils.getBaggageMaxLength() / 2) {
            SelfLog.infoWithTraceId("Get biz baggage from upstream system, and the length is " + bizBaggageAttrs.length());
        }
    }

    public void deserializeSysBaggage(String sysBaggageAttrs) {
        StringUtils.stringToMap(sysBaggageAttrs, this.sysBaggage);
        if (StringUtils.isNotBlank(sysBaggageAttrs) && sysBaggageAttrs.length() > TracerUtils.getSysBaggageMaxLength() / 2) {
            SelfLog.infoWithTraceId("Get system baggage from upstream system, and the length is " + sysBaggageAttrs.length());
        }
    }

    public String serializeSpanContext() {
        StringBuilder serializedValue = new StringBuilder();
        serializedValue.append(TRACE_ID_KET).append("=").append(this.traceId).append("&");
        serializedValue.append(SPAN_ID_KET).append("=").append(this.spanId).append("&");
        serializedValue.append(PARENT_SPAN_ID_KET).append("=").append(this.parentId).append("&");
        serializedValue.append(SAMPLE_KET).append("=").append(this.isSampled).append("&");
        if (this.sysBaggage.size() > 0) {
            serializedValue.append(StringUtils.mapToStringWithPrefix(this.sysBaggage, SYS_BAGGAGE_PREFIX_KEY));
        }
        if (this.bizBaggage.size() > 0) {
            serializedValue.append(StringUtils.mapToString(this.bizBaggage));
        }
        return serializedValue.toString();
    }

    public static SofaTracerSpanContext deserializeFromString(String deserializeValue) {
        if (StringUtils.isBlank(deserializeValue)) {
            return SofaTracerSpanContext.rootStart();
        }
        String traceId = TraceIdGenerator.generate();
        String spanId = "0";
        String parentId = "";
        boolean sampled = true;
        HashMap<String, String> sysBaggage = new HashMap<String, String>();
        HashMap<String, String> baggage = new HashMap<String, String>();
        HashMap<String, String> spanContext = new HashMap<String, String>();
        StringUtils.stringToMap(deserializeValue, spanContext);
        for (Map.Entry entry : spanContext.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isBlank(key) || StringUtils.isBlank(value)) continue;
            if (TRACE_ID_KET.equals(key)) {
                traceId = value;
                continue;
            }
            if (SPAN_ID_KET.equals(key)) {
                spanId = value;
                continue;
            }
            if (PARENT_SPAN_ID_KET.equals(key)) {
                parentId = value;
                continue;
            }
            if (SAMPLE_KET.equals(key)) {
                sampled = Boolean.parseBoolean(value);
                continue;
            }
            int sysIndex = key.indexOf(SYS_BAGGAGE_PREFIX_KEY);
            if (sysIndex == 0) {
                String sysKey = key.substring(SYS_BAGGAGE_PREFIX_KEY.length());
                sysBaggage.put(sysKey, value);
                continue;
            }
            baggage.put(key, value);
        }
        SofaTracerSpanContext sofaTracerSpanContext = new SofaTracerSpanContext(traceId, spanId, parentId, sampled);
        if (sysBaggage.size() > 0) {
            sofaTracerSpanContext.addSysBaggage(sysBaggage);
        }
        if (baggage.size() > 0) {
            sofaTracerSpanContext.addBizBaggage(baggage);
        }
        return sofaTracerSpanContext;
    }

    public static SofaTracerSpanContext rootStart() {
        return SofaTracerSpanContext.rootStart(true);
    }

    public static SofaTracerSpanContext rootStart(boolean isSampled) {
        String traceId = TraceIdGenerator.generate();
        return new SofaTracerSpanContext(traceId, "0", "", isSampled);
    }

    private String genParentSpanId(String spanId) {
        return StringUtils.isBlank(spanId) || spanId.lastIndexOf(RPC_ID_SEPARATOR) < 0 ? "" : spanId.substring(0, spanId.lastIndexOf(RPC_ID_SEPARATOR));
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
        this.parentId = this.genParentSpanId(spanId);
    }

    public SofaTracerSpanContext setBizBaggageItem(String key, String value) {
        if (StringUtils.isBlank(key)) {
            return this;
        }
        this.bizBaggage.put(key, value);
        return this;
    }

    public String getBizBaggageItem(String key) {
        return this.bizBaggage.get(key);
    }

    public SofaTracerSpanContext setSysBaggageItem(String key, String value) {
        if (StringUtils.isBlank(key) || StringUtils.isBlank(value)) {
            return this;
        }
        this.sysBaggage.put(key, value);
        return this;
    }

    public String getSysBaggageItem(String key) {
        return this.sysBaggage.get(key);
    }

    public String getTraceId() {
        return StringUtils.isBlank(this.traceId) ? "" : this.traceId;
    }

    public String getSpanId() {
        return StringUtils.isBlank(this.spanId) ? "" : this.spanId;
    }

    public String getParentId() {
        return StringUtils.isBlank(this.parentId) ? "" : this.parentId;
    }

    public Map<String, String> getBizBaggage() {
        return this.bizBaggage;
    }

    public Map<String, String> getSysBaggage() {
        return this.sysBaggage;
    }

    public boolean isSampled() {
        return this.isSampled;
    }

    public void setSampled(boolean sampled) {
        this.isSampled = sampled;
    }

    public AtomicInteger getChildContextIndex() {
        return this.childContextIndex;
    }

    public String nextChildContextId() {
        return this.spanId + RPC_ID_SEPARATOR + this.childContextIndex.incrementAndGet();
    }

    public String lastChildContextId() {
        return this.spanId + RPC_ID_SEPARATOR + this.childContextIndex.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SofaTracerSpanContext)) {
            return false;
        }
        SofaTracerSpanContext that = (SofaTracerSpanContext)o;
        if (!this.traceId.equals(that.traceId)) {
            return false;
        }
        if (!this.spanId.equals(that.spanId)) {
            return false;
        }
        if (StringUtils.isBlank(this.parentId)) {
            return StringUtils.isBlank(that.parentId);
        }
        return this.parentId.equals(that.parentId);
    }

    public int hashCode() {
        int result = this.traceId.hashCode();
        result = 31 * result + this.spanId.hashCode();
        result = 31 * result + this.parentId.hashCode();
        return result;
    }

    public String toString() {
        return "SofaTracerSpanContext{traceId='" + this.traceId + '\'' + ", spanId='" + this.spanId + '\'' + ", parentId='" + this.parentId + '\'' + ", isSampled=" + this.isSampled + ", bizBaggage=" + this.bizBaggage + ", sysBaggage=" + this.sysBaggage + ", childContextIndex=" + this.childContextIndex + '}';
    }
}

