/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.function.ToIntFunction;

public class SofaTracerToIntFunction<T>
implements ToIntFunction<T> {
    private final FunctionalAsyncSupport functionalAsyncSupport;
    private final ToIntFunction<T> wrappedToIntFunction;

    public SofaTracerToIntFunction(ToIntFunction<T> wrappedToIntFunction) {
        this.wrappedToIntFunction = wrappedToIntFunction;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(SofaTraceContextHolder.getSofaTraceContext());
    }

    @Override
    public int applyAsInt(T value) {
        this.functionalAsyncSupport.doBefore();
        try {
            int n = this.wrappedToIntFunction.applyAsInt(value);
            return n;
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

