/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;

public class SofaTracerRunnable
implements Runnable {
    private Runnable wrappedRunnable;
    protected FunctionalAsyncSupport functionalAsyncSupport;

    public SofaTracerRunnable(Runnable wrappedRunnable) {
        this.initRunnable(wrappedRunnable, SofaTraceContextHolder.getSofaTraceContext());
    }

    public SofaTracerRunnable(Runnable wrappedRunnable, SofaTraceContext traceContext) {
        this.initRunnable(wrappedRunnable, traceContext);
    }

    private void initRunnable(Runnable wrappedRunnable, SofaTraceContext traceContext) {
        this.wrappedRunnable = wrappedRunnable;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(traceContext);
    }

    @Override
    public void run() {
        this.functionalAsyncSupport.doBefore();
        try {
            this.wrappedRunnable.run();
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

