/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.function.Predicate;

public class SofaTracerPredicate<T>
implements Predicate<T> {
    private final Predicate<T> wrappedPredicate;
    private final FunctionalAsyncSupport functionalAsyncSupport;

    public SofaTracerPredicate(Predicate<T> wrappedPredicate) {
        this.wrappedPredicate = wrappedPredicate;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(SofaTraceContextHolder.getSofaTraceContext());
    }

    @Override
    public boolean test(T t) {
        this.functionalAsyncSupport.doBefore();
        try {
            boolean bl = this.wrappedPredicate.test(t);
            return bl;
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

