/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.function.IntFunction;

public class SofaTracerIntFunction<R>
implements IntFunction<R> {
    private final FunctionalAsyncSupport functionalAsyncSupport;
    private final IntFunction<R> wrappedIntFunction;

    public SofaTracerIntFunction(IntFunction<R> wrappedIntFunction) {
        this.wrappedIntFunction = wrappedIntFunction;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(SofaTraceContextHolder.getSofaTraceContext());
    }

    @Override
    public R apply(int value) {
        this.functionalAsyncSupport.doBefore();
        try {
            R r = this.wrappedIntFunction.apply(value);
            return r;
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

