/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.function.Function;

public class SofaTracerFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> wrappedFunction;
    private final FunctionalAsyncSupport functionalAsyncSupport;

    public SofaTracerFunction(Function<T, R> wrappedFunction) {
        this.wrappedFunction = wrappedFunction;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(SofaTraceContextHolder.getSofaTraceContext());
    }

    @Override
    public R apply(T t) {
        this.functionalAsyncSupport.doBefore();
        try {
            R r = this.wrappedFunction.apply(t);
            return r;
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

