/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.function.Consumer;

public class SofaTracerConsumer<T>
implements Consumer<T> {
    private final Consumer<T> wrappedConsumer;
    private final FunctionalAsyncSupport functionalAsyncSupport;

    public SofaTracerConsumer(Consumer<T> wrappedConsumer) {
        this.wrappedConsumer = wrappedConsumer;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(SofaTraceContextHolder.getSofaTraceContext());
    }

    @Override
    public void accept(T t) {
        this.functionalAsyncSupport.doBefore();
        try {
            this.wrappedConsumer.accept(t);
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

