/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.FunctionalAsyncSupport;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.concurrent.Callable;

public class SofaTracerCallable<T>
implements Callable<T> {
    private Callable<T> wrappedCallable;
    private FunctionalAsyncSupport functionalAsyncSupport;

    public SofaTracerCallable(Callable<T> wrappedCallable) {
        this.initCallable(wrappedCallable, SofaTraceContextHolder.getSofaTraceContext());
    }

    public SofaTracerCallable(Callable<T> wrappedCallable, SofaTraceContext traceContext) {
        this.initCallable(wrappedCallable, traceContext);
    }

    private void initCallable(Callable<T> wrappedCallable, SofaTraceContext traceContext) {
        this.wrappedCallable = wrappedCallable;
        this.functionalAsyncSupport = new FunctionalAsyncSupport(traceContext);
    }

    @Override
    public T call() throws Exception {
        this.functionalAsyncSupport.doBefore();
        try {
            T t = this.wrappedCallable.call();
            return t;
        }
        finally {
            this.functionalAsyncSupport.doFinally();
        }
    }
}

