/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.extensions.SpanExtensionFactory;
import com.alipay.common.tracer.core.span.SofaTracerSpan;

public class FunctionalAsyncSupport {
    private final long tid = Thread.currentThread().getId();
    protected final SofaTraceContext traceContext;
    private final SofaTracerSpan currentSpan;

    public FunctionalAsyncSupport(SofaTraceContext traceContext) {
        this.traceContext = traceContext;
        this.currentSpan = !traceContext.isEmpty() ? traceContext.getCurrentSpan() : null;
    }

    public void doBefore() {
        if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
            this.traceContext.push(this.currentSpan);
            SpanExtensionFactory.logStartedSpan(this.currentSpan);
        }
    }

    public void doFinally() {
        if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
            this.traceContext.pop();
        }
    }
}

