/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.generator.TraceIdGenerator;
import com.alipay.common.tracer.core.listener.SpanReportListener;
import com.alipay.common.tracer.core.listener.SpanReportListenerHolder;
import com.alipay.common.tracer.core.registry.RegistryExtractorInjector;
import com.alipay.common.tracer.core.registry.TracerFormatRegistry;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.samplers.SamplerFactory;
import com.alipay.common.tracer.core.samplers.SamplingStatus;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.span.SofaTracerSpanReferenceRelationship;
import com.alipay.common.tracer.core.utils.AssertUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.common.code.LogCode2Description;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SofaTracer
implements Tracer {
    public static final String ROOT_SPAN_ID = "0";
    private final String tracerType;
    private final Reporter clientReporter;
    private final Reporter serverReporter;
    private final Map<String, Object> tracerTags = new ConcurrentHashMap<String, Object>();
    private final Sampler sampler;

    protected SofaTracer(String tracerType, Reporter clientReporter, Reporter serverReporter, Sampler sampler, Map<String, Object> tracerTags) {
        this.tracerType = tracerType;
        this.clientReporter = clientReporter;
        this.serverReporter = serverReporter;
        this.sampler = sampler;
        if (tracerTags != null && tracerTags.size() > 0) {
            this.tracerTags.putAll(tracerTags);
        }
    }

    protected SofaTracer(String tracerType, Sampler sampler) {
        this.tracerType = tracerType;
        this.clientReporter = null;
        this.serverReporter = null;
        this.sampler = sampler;
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SofaTracerSpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        RegistryExtractorInjector<C> registryInjector = TracerFormatRegistry.getRegistry(format);
        if (registryInjector == null) {
            throw new IllegalArgumentException("Unsupported injector format: " + format);
        }
        registryInjector.inject((SofaTracerSpanContext)spanContext, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        RegistryExtractorInjector<C> registryExtractor = TracerFormatRegistry.getRegistry(format);
        if (registryExtractor == null) {
            throw new IllegalArgumentException("Unsupported extractor format: " + format);
        }
        return registryExtractor.extract(carrier);
    }

    public void reportSpan(SofaTracerSpan span) {
        if (span == null) {
            return;
        }
        if (this.sampler != null && span.isClient() && span.getParentSofaTracerSpan() == null) {
            span.getSofaTracerSpanContext().setSampled(this.sampler.sample(span).isSampled());
        }
        this.invokeReportListeners(span);
        if (span.isClient() || this.getTracerType().equalsIgnoreCase("flexible-biz")) {
            if (this.clientReporter != null) {
                this.clientReporter.report(span);
            }
        } else if (span.isServer()) {
            if (this.serverReporter != null) {
                this.serverReporter.report(span);
            }
        } else {
            SelfLog.warn("Span reported neither client nor server.Ignore!");
        }
    }

    public void close() {
        if (this.clientReporter != null) {
            this.clientReporter.close();
        }
        if (this.serverReporter != null) {
            this.serverReporter.close();
        }
        if (this.sampler != null) {
            this.sampler.close();
        }
    }

    public String getTracerType() {
        return this.tracerType;
    }

    public Reporter getClientReporter() {
        return this.clientReporter;
    }

    public Reporter getServerReporter() {
        return this.serverReporter;
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public Map<String, Object> getTracerTags() {
        return this.tracerTags;
    }

    public String toString() {
        return "SofaTracer{tracerType='" + this.tracerType + '}';
    }

    protected void invokeReportListeners(SofaTracerSpan sofaTracerSpan) {
        List<SpanReportListener> listeners = SpanReportListenerHolder.getSpanReportListenersHolder();
        if (listeners != null && listeners.size() > 0) {
            for (SpanReportListener listener : listeners) {
                listener.onSpanReport(sofaTracerSpan);
            }
        }
    }

    public static final class Builder {
        private final String tracerType;
        private Reporter clientReporter;
        private Reporter serverReporter;
        private Map<String, Object> tracerTags = new HashMap<String, Object>();
        private Sampler sampler;

        public Builder(String tracerType) {
            AssertUtils.isTrue(StringUtils.isNotBlank(tracerType), "tracerType must be not empty");
            this.tracerType = tracerType;
        }

        public Builder withClientReporter(Reporter clientReporter) {
            this.clientReporter = clientReporter;
            return this;
        }

        public Builder withServerReporter(Reporter serverReporter) {
            this.serverReporter = serverReporter;
            return this;
        }

        public Builder withSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public Builder withTag(String key, String value) {
            this.tracerTags.put(key, value);
            return this;
        }

        public Builder withTag(String key, Boolean value) {
            this.tracerTags.put(key, value);
            return this;
        }

        public Builder withTag(String key, Number value) {
            this.tracerTags.put(key, value);
            return this;
        }

        public Builder withTags(Map<String, ?> tags) {
            if (tags == null || tags.size() <= 0) {
                return this;
            }
            for (Map.Entry<String, ?> entry : tags.entrySet()) {
                Object value;
                String key = entry.getKey();
                if (StringUtils.isBlank(key) || (value = entry.getValue()) == null) continue;
                if (value instanceof String) {
                    this.withTag(key, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    this.withTag(key, (Boolean)value);
                    continue;
                }
                if (value instanceof Number) {
                    this.withTag(key, (Number)value);
                    continue;
                }
                SelfLog.error(String.format(LogCode2Description.convert((String)"sofa-tracer", (String)"01-00003"), value.getClass().toString()));
            }
            return this;
        }

        public SofaTracer build() {
            try {
                this.sampler = SamplerFactory.getSampler();
            }
            catch (Exception e) {
                SelfLog.error(LogCode2Description.convert((String)"sofa-tracer", (String)"01-00002"));
            }
            return new SofaTracer(this.tracerType, this.clientReporter, this.serverReporter, this.sampler, this.tracerTags);
        }
    }

    public class SofaTracerSpanBuilder
    implements Tracer.SpanBuilder {
        private String operationName;
        private long startTime = -1L;
        private List<SofaTracerSpanReferenceRelationship> references = Collections.emptyList();
        private final Map<String, Object> tags = new HashMap<String, Object>();

        public SofaTracerSpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public Tracer.SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public Tracer.SpanBuilder asChildOf(Span parentSpan) {
            if (parentSpan == null) {
                return this;
            }
            return this.addReference("child_of", parentSpan.context());
        }

        public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (referencedContext == null) {
                return this;
            }
            if (!(referencedContext instanceof SofaTracerSpanContext)) {
                return this;
            }
            if (!"child_of".equals(referenceType) && !"follows_from".equals(referenceType)) {
                return this;
            }
            if (this.references.isEmpty()) {
                this.references = Collections.singletonList(new SofaTracerSpanReferenceRelationship((SofaTracerSpanContext)referencedContext, referenceType));
            } else {
                if (this.references.size() == 1) {
                    this.references = new ArrayList<SofaTracerSpanReferenceRelationship>(this.references);
                }
                this.references.add(new SofaTracerSpanReferenceRelationship((SofaTracerSpanContext)referencedContext, referenceType));
            }
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.startTime = microseconds;
            return this;
        }

        public Span start() {
            SofaTracerSpanContext sofaTracerSpanContext = this.references != null && this.references.size() > 0 ? this.createChildContext() : this.createRootSpanContext();
            long begin = this.startTime > 0L ? this.startTime : System.currentTimeMillis();
            SofaTracerSpan sofaTracerSpan = new SofaTracerSpan(SofaTracer.this, begin, this.references, this.operationName, sofaTracerSpanContext, this.tags);
            boolean isSampled = this.calculateSampler(sofaTracerSpan);
            sofaTracerSpanContext.setSampled(isSampled);
            return sofaTracerSpan;
        }

        private boolean calculateSampler(SofaTracerSpan sofaTracerSpan) {
            SamplingStatus samplingStatus;
            boolean isSampled = false;
            if (this.references != null && this.references.size() > 0) {
                SofaTracerSpanContext preferredReference = this.preferredReference();
                isSampled = preferredReference.isSampled();
            } else if (SofaTracer.this.sampler != null && (samplingStatus = SofaTracer.this.sampler.sample(sofaTracerSpan)).isSampled()) {
                isSampled = true;
                this.tags.putAll(samplingStatus.getTags());
            }
            return isSampled;
        }

        private SofaTracerSpanContext createRootSpanContext() {
            String traceId = TraceIdGenerator.generate();
            return new SofaTracerSpanContext(traceId, SofaTracer.ROOT_SPAN_ID, "");
        }

        private SofaTracerSpanContext createChildContext() {
            SofaTracerSpanContext preferredReference = this.preferredReference();
            SofaTracerSpanContext sofaTracerSpanContext = new SofaTracerSpanContext(preferredReference.getTraceId(), preferredReference.nextChildContextId(), preferredReference.getSpanId(), preferredReference.isSampled());
            sofaTracerSpanContext.addBizBaggage(this.createChildBaggage(true));
            sofaTracerSpanContext.addSysBaggage(this.createChildBaggage(false));
            return sofaTracerSpanContext;
        }

        private Map<String, String> createChildBaggage(boolean isBiz) {
            if (this.references.size() == 1) {
                if (isBiz) {
                    return this.references.get(0).getSofaTracerSpanContext().getBizBaggage();
                }
                return this.references.get(0).getSofaTracerSpanContext().getSysBaggage();
            }
            HashMap<String, String> baggage = null;
            for (SofaTracerSpanReferenceRelationship reference : this.references) {
                Map<String, String> referenceBaggage = isBiz ? reference.getSofaTracerSpanContext().getBizBaggage() : reference.getSofaTracerSpanContext().getSysBaggage();
                if (referenceBaggage == null || referenceBaggage.size() <= 0) continue;
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.putAll(referenceBaggage);
            }
            return baggage;
        }

        private SofaTracerSpanContext preferredReference() {
            SofaTracerSpanReferenceRelationship preferredReference = this.references.get(0);
            for (SofaTracerSpanReferenceRelationship reference : this.references) {
                String referencedType = reference.getReferenceType();
                if (!"child_of".equals(referencedType) || "child_of".equals(preferredReference.getReferenceType())) continue;
                preferredReference = reference;
                break;
            }
            return preferredReference.getSofaTracerSpanContext();
        }
    }
}

