/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.tracer;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.reporter.digest.DiskReporterImpl;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.util.Map;

public abstract class AbstractTracer {
    protected SofaTracer sofaTracer;

    public AbstractTracer(String tracerType) {
        this(tracerType, true, true);
    }

    public AbstractTracer(String tracerType, boolean clientTracer, boolean serverTracer) {
        Reporter serverReporter;
        Reporter clientReporter;
        SofaTracer.Builder builder = new SofaTracer.Builder(tracerType);
        if (clientTracer && (clientReporter = this.generateReporter(this.generateClientStatReporter(), this.getClientDigestReporterLogName(), this.getClientDigestReporterRollingKey(), this.getClientDigestReporterLogNameKey(), this.getClientDigestEncoder())) != null) {
            builder.withClientReporter(clientReporter);
        }
        if (serverTracer && (serverReporter = this.generateReporter(this.generateServerStatReporter(), this.getServerDigestReporterLogName(), this.getServerDigestReporterRollingKey(), this.getServerDigestReporterLogNameKey(), this.getServerDigestEncoder())) != null) {
            builder.withServerReporter(serverReporter);
        }
        this.sofaTracer = builder.build();
    }

    protected Reporter generateReporter(AbstractSofaTracerStatisticReporter statReporter, String logName, String logRollingKey, String logNameKey, SpanEncoder<SofaTracerSpan> spanEncoder) {
        String digestRollingPolicy = SofaTracerConfiguration.getRollingPolicy(logRollingKey);
        String digestLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig(logNameKey);
        DiskReporterImpl reporter = new DiskReporterImpl(logName, digestRollingPolicy, digestLogReserveConfig, spanEncoder, statReporter, logNameKey);
        return reporter;
    }

    protected abstract String getClientDigestReporterLogName();

    protected abstract String getClientDigestReporterRollingKey();

    protected abstract String getClientDigestReporterLogNameKey();

    protected abstract SpanEncoder<SofaTracerSpan> getClientDigestEncoder();

    protected abstract AbstractSofaTracerStatisticReporter generateClientStatReporter();

    protected abstract String getServerDigestReporterLogName();

    protected abstract String getServerDigestReporterRollingKey();

    protected abstract String getServerDigestReporterLogNameKey();

    protected abstract SpanEncoder<SofaTracerSpan> getServerDigestEncoder();

    protected abstract AbstractSofaTracerStatisticReporter generateServerStatReporter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaTracerSpan clientSend(String operationName) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.pop();
        SofaTracerSpan clientSpan = null;
        try {
            clientSpan = (SofaTracerSpan)this.sofaTracer.buildSpan(operationName).asChildOf((Span)serverSpan).start();
            clientSpan.setParentSofaTracerSpan(serverSpan);
            SofaTracerSpan sofaTracerSpan = clientSpan;
            return sofaTracerSpan;
        }
        catch (Throwable throwable) {
            SelfLog.errorWithTraceId("Client Send Error And Restart by Root Span", throwable);
            SelfLog.flush();
            Map<String, String> bizBaggage = null;
            Map<String, String> sysBaggage = null;
            if (serverSpan != null) {
                bizBaggage = serverSpan.getSofaTracerSpanContext().getBizBaggage();
                sysBaggage = serverSpan.getSofaTracerSpanContext().getSysBaggage();
            }
            clientSpan = this.errorRecover(bizBaggage, sysBaggage);
        }
        finally {
            if (clientSpan != null) {
                clientSpan.setTag(Tags.SPAN_KIND.getKey(), "client");
                clientSpan.setTag("current.thread.name", Thread.currentThread().getName());
                clientSpan.log("cs");
                sofaTraceContext.push(clientSpan);
            }
        }
        return clientSpan;
    }

    public void clientReceive(String resultCode) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.pop();
        if (clientSpan == null) {
            return;
        }
        this.clientReceiveTagFinish(clientSpan, resultCode);
        if (clientSpan.getParentSofaTracerSpan() != null) {
            sofaTraceContext.push(clientSpan.getParentSofaTracerSpan());
        }
    }

    public void clientReceiveTagFinish(SofaTracerSpan clientSpan, String resultCode) {
        if (clientSpan != null) {
            clientSpan.log("cr");
            clientSpan.setTag("result.code", resultCode);
            clientSpan.finish();
        }
    }

    public SofaTracerSpan serverReceive() {
        return this.serverReceive(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaTracerSpan serverReceive(SofaTracerSpanContext sofaTracerSpanContext) {
        SofaTracerSpan newSpan = null;
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.pop();
        try {
            newSpan = serverSpan == null ? (SofaTracerSpan)this.sofaTracer.buildSpan("").asChildOf((SpanContext)sofaTracerSpanContext).start() : (SofaTracerSpan)this.sofaTracer.buildSpan("").asChildOf((Span)serverSpan).start();
        }
        catch (Throwable throwable) {
            SelfLog.errorWithTraceId("Middleware server received and restart root span", throwable);
            SelfLog.flush();
            Map<String, String> bizBaggage = null;
            Map<String, String> sysBaggage = null;
            if (serverSpan != null) {
                bizBaggage = serverSpan.getSofaTracerSpanContext().getBizBaggage();
                sysBaggage = serverSpan.getSofaTracerSpanContext().getSysBaggage();
            }
            newSpan = this.errorRecover(bizBaggage, sysBaggage);
        }
        finally {
            if (newSpan != null) {
                newSpan.log("sr");
                newSpan.setTag(Tags.SPAN_KIND.getKey(), "server");
                newSpan.setTag("current.thread.name", Thread.currentThread().getName());
                sofaTraceContext.push(newSpan);
            }
        }
        return newSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverSend(String resultCode) {
        try {
            SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
            SofaTracerSpan serverSpan = sofaTraceContext.pop();
            if (serverSpan == null) {
                return;
            }
            serverSpan.log("ss");
            serverSpan.setTag("result.code", resultCode);
            serverSpan.finish();
        }
        finally {
            this.clearTreadLocalContext();
        }
    }

    protected SofaTracerSpan genSeverSpanInstance(long startTime, String operationName, SofaTracerSpanContext sofaTracerSpanContext, Map<String, ?> tags) {
        return new SofaTracerSpan(this.sofaTracer, startTime, null, operationName, sofaTracerSpanContext, tags);
    }

    private void clearTreadLocalContext() {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        sofaTraceContext.clear();
    }

    protected SofaTracerSpan errorRecover(Map<String, String> bizBaggage, Map<String, String> sysBaggage) {
        SofaTracerSpanContext spanContext = SofaTracerSpanContext.rootStart();
        spanContext.addBizBaggage(bizBaggage);
        spanContext.addSysBaggage(sysBaggage);
        SofaTracerSpan span = this.genSeverSpanInstance(System.currentTimeMillis(), "", spanContext, null);
        return span;
    }

    public SofaTracer getSofaTracer() {
        return this.sofaTracer;
    }
}

