/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import java.util.concurrent.Callable;

public class SofaTracerCallable<T>
implements Callable<T> {
    private long tid = Thread.currentThread().getId();
    private Callable<T> wrappedCallable;
    private SofaTraceContext traceContext;
    private SofaTracerSpan currentSpan;

    public SofaTracerCallable(Callable<T> wrappedCallable) {
        this.initCallable(wrappedCallable, SofaTraceContextHolder.getSofaTraceContext());
    }

    public SofaTracerCallable(Callable<T> wrappedCallable, SofaTraceContext traceContext) {
        this.initCallable(wrappedCallable, traceContext);
    }

    private void initCallable(Callable<T> wrappedCallable, SofaTraceContext traceContext) {
        this.wrappedCallable = wrappedCallable;
        this.traceContext = traceContext;
        this.currentSpan = !traceContext.isEmpty() ? traceContext.getCurrentSpan() : null;
    }

    @Override
    public T call() throws Exception {
        if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
            this.traceContext.push(this.currentSpan);
        }
        try {
            T t = this.wrappedCallable.call();
            return t;
        }
        finally {
            if (Thread.currentThread().getId() != this.tid && this.currentSpan != null) {
                this.traceContext.pop();
            }
        }
    }
}

