/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.file;

import com.alipay.common.tracer.core.appender.config.LogReserveConfig;
import com.alipay.common.tracer.core.appender.file.AbstractRollingFileAppender;
import com.alipay.common.tracer.core.appender.file.RollingCalendar;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.appender.self.TracerDaemon;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimedRollingFileAppender
extends AbstractRollingFileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_SECONDS = 0;
    static final int TOP_OF_MINUTE = 1;
    static final int TOP_OF_HOUR = 2;
    static final int HALF_DAY = 3;
    static final int TOP_OF_DAY = 4;
    static final int TOP_OF_WEEK = 5;
    static final int TOP_OF_MONTH = 6;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    public static final String DAILY_ROLLING_PATTERN = "'.'yyyy-MM-dd";
    public static final String HOURLY_ROLLING_PATTERN = "'.'yyyy-MM-dd_HH";
    private static final String DEFAULT_ROLLING_PATTERN = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    private String datePattern;
    private SimpleDateFormat sdf;
    private Date now = new Date();
    private RollingCalendar rc = new RollingCalendar();
    private LogReserveConfig logReserveConfig = new LogReserveConfig(7, 0);

    public TimedRollingFileAppender(String file, boolean append) {
        this(file, 8192, append, "'.'yyyy-MM-dd");
    }

    public TimedRollingFileAppender(String file, String datePattern) {
        this(file, 8192, true, datePattern);
    }

    public TimedRollingFileAppender(String file, String datePattern, String logReserveConfigString) {
        this(file, 8192, true, datePattern);
        this.logReserveConfig = TracerUtils.parseLogReserveConfig(logReserveConfigString);
    }

    public TimedRollingFileAppender(String file, int bufferSize, boolean append) {
        this(file, bufferSize, append, "'.'yyyy-MM-dd");
    }

    public TimedRollingFileAppender(String file, int bufferSize, boolean append, String datePatternParam) {
        super(file, bufferSize, append);
        this.datePattern = StringUtils.isBlank(datePatternParam) ? "'.'yyyy-MM-dd" : datePatternParam;
        this.sdf = new SimpleDateFormat(this.datePattern);
        this.rc.setType(this.computeCheckPeriod());
        this.scheduledFilename = this.fileName + this.sdf.format(new Date(this.logFile.lastModified()));
        TracerDaemon.watch(this);
    }

    @Override
    public boolean shouldRollOverNow() {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            return true;
        }
        return false;
    }

    @Override
    public void cleanup() {
        try {
            File parentDirectory = this.logFile.getParentFile();
            if (parentDirectory == null || !parentDirectory.isDirectory()) {
                return;
            }
            final String baseName = this.logFile.getName();
            if (StringUtils.isBlank(baseName)) {
                return;
            }
            File[] logFiles = parentDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return StringUtils.isNotBlank(name) && name.startsWith(baseName);
                }
            });
            if (logFiles == null || logFiles.length == 0) {
                return;
            }
            for (File logFile : logFiles) {
                boolean success;
                String logFileName = logFile.getName();
                int lastDot = logFileName.lastIndexOf(".");
                if (lastDot < 0) continue;
                String logTime = logFileName.substring(lastDot);
                SimpleDateFormat dailyRollingSdf = new SimpleDateFormat("'.'yyyy-MM-dd");
                SimpleDateFormat hourlyRollingSdf = new SimpleDateFormat(HOURLY_ROLLING_PATTERN);
                if (".log".equalsIgnoreCase(logTime)) continue;
                Date date = null;
                try {
                    date = hourlyRollingSdf.parse(logTime);
                }
                catch (ParseException e) {
                    try {
                        date = dailyRollingSdf.parse(logTime);
                    }
                    catch (ParseException pe) {
                        SelfLog.error("Unable to get log time of log file " + logFileName + ", the reason is " + pe.getMessage());
                    }
                }
                if (date == null) continue;
                Calendar now = Calendar.getInstance();
                now.add(5, 0 - this.logReserveConfig.getDay());
                if (this.logReserveConfig.getHour() > 0) {
                    now.add(11, 0 - this.logReserveConfig.getHour());
                } else {
                    now.set(11, 0);
                }
                now.set(12, 0);
                now.set(13, 0);
                now.set(14, 0);
                Calendar compareCal = Calendar.getInstance();
                compareCal.clear();
                compareCal.set(1, now.get(1));
                compareCal.set(2, now.get(2));
                compareCal.set(5, now.get(5));
                compareCal.set(11, now.get(11));
                Calendar logCal = Calendar.getInstance();
                logCal.setTime(date);
                if (!logCal.before(compareCal)) continue;
                boolean bl = success = logFile.delete() && !logFile.exists();
                if (success) {
                    SelfLog.info("Deleted log file: " + logFileName);
                    continue;
                }
                SelfLog.error("Fail to delete log file: " + logFileName);
            }
        }
        catch (Throwable e) {
            SelfLog.error("Failed to clean up log file", e);
        }
    }

    @Override
    public void rollOver() {
        boolean result;
        if (this.datePattern == null) {
            SelfLog.error("\u6ca1\u6709\u8bbe\u7f6e\u6587\u4ef6\u6eda\u52a8\u7684\u540e\u7f00\u540d\u6a21\u5f0f");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        try {
            this.bos.close();
        }
        catch (IOException e) {
            SelfLog.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", e);
        }
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = this.logFile.renameTo(target)) {
            System.out.println(this.fileName + " -> " + this.scheduledFilename);
        } else {
            System.err.println("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
        }
        this.setFile(false);
        this.scheduledFilename = datedFilename;
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 6; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }
}

