/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.file;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.TracerLogRootDaemon;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractRollingFileAppender
implements TraceAppender {
    private static final long LOG_FLUSH_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final long IOEXCEPTION_PRINT_INTERVAL = 60000L;
    private final int bufferSize;
    protected final String fileName;
    private final AtomicBoolean isRolling = new AtomicBoolean(false);
    protected File logFile = null;
    protected BufferedOutputStream bos = null;
    private long nextFlushTime = 0L;
    private long nextIOExceptionPrintTime = 0L;

    public AbstractRollingFileAppender(String file, boolean append) {
        this(file, 8192, append);
    }

    public AbstractRollingFileAppender(String file, int bufferSize, boolean append) {
        this.fileName = TracerLogRootDaemon.LOG_FILE_DIR + File.separator + file;
        this.bufferSize = bufferSize;
        this.setFile(append);
    }

    protected void setFile(boolean append) {
        try {
            this.logFile = new File(this.fileName);
            if (!this.logFile.exists()) {
                File parentFile = this.logFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    this.doSelfLog("[ERROR] Fail to mkdirs: " + parentFile.getAbsolutePath());
                    return;
                }
                if (!this.logFile.createNewFile()) {
                    this.doSelfLog("[ERROR] Fail to create file to write: " + this.logFile.getAbsolutePath());
                    return;
                }
            }
            if (!this.logFile.isFile() || !this.logFile.canWrite()) {
                this.doSelfLog("[ERROR] Invalid file, exists=" + this.logFile.exists() + ", isFile=" + this.logFile.isFile() + ", canWrite=" + this.logFile.canWrite() + ", path=" + this.logFile.getAbsolutePath());
                return;
            }
            FileOutputStream ostream = new FileOutputStream(this.logFile, append);
            this.bos = new BufferedOutputStream(ostream, this.bufferSize);
        }
        catch (Throwable e) {
            SelfLog.error("setFile error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String log) throws IOException {
        if (this.bos != null) {
            this.waitUntilRollFinish();
            if (this.shouldRollOverNow() && this.isRolling.compareAndSet(false, true)) {
                try {
                    this.rollOver();
                    this.nextFlushTime = System.currentTimeMillis() + LOG_FLUSH_INTERVAL;
                }
                finally {
                    this.isRolling.set(false);
                }
            } else {
                long now = System.currentTimeMillis();
                if (now >= this.nextFlushTime) {
                    this.flush();
                    this.nextFlushTime = now + LOG_FLUSH_INTERVAL;
                }
            }
            byte[] bytes = log.getBytes(TracerLogRootDaemon.DEFAULT_CHARSET);
            this.write(bytes);
        }
    }

    protected abstract boolean shouldRollOverNow();

    protected abstract void rollOver();

    private void write(byte[] bytes) {
        block2: {
            try {
                this.bos.write(bytes);
            }
            catch (IOException e) {
                long now = System.currentTimeMillis();
                if (now <= this.nextIOExceptionPrintTime) break block2;
                this.nextIOExceptionPrintTime = now + 60000L;
                SelfLog.error("Failed to write file " + this.fileName, e);
            }
        }
    }

    @Override
    public void flush() {
        block3: {
            if (this.bos != null) {
                try {
                    this.bos.flush();
                }
                catch (IOException e) {
                    long now = System.currentTimeMillis();
                    if (now <= this.nextIOExceptionPrintTime) break block3;
                    this.nextIOExceptionPrintTime = now + 60000L;
                    SelfLog.error("Failed to flush file " + this.fileName, e);
                }
            }
        }
    }

    void waitUntilRollFinish() {
        while (this.isRolling.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                SelfLog.error("WaitUntilRollFinish error!", e);
            }
        }
    }

    private void doSelfLog(String log) {
        System.out.println("[TraceSelfLog]" + log);
    }
}

