/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.builder;

public class JsonStringBuilder {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private StringBuilder sb;
    private boolean isValueNullCheck = false;

    public JsonStringBuilder() {
        this(false, 256);
    }

    public JsonStringBuilder(boolean isValueNullCheck) {
        this(isValueNullCheck, 256);
    }

    public JsonStringBuilder(boolean isValueNullCheck, int size) {
        this.isValueNullCheck = isValueNullCheck;
        this.sb = new StringBuilder(size);
    }

    public JsonStringBuilder appendBegin() {
        this.sb.append('{');
        return this;
    }

    public JsonStringBuilder appendBegin(String key, Object value) {
        this.appendBegin();
        this.append(key, value);
        return this;
    }

    public JsonStringBuilder append(String key, Object value) {
        if (value == null && this.isValueNullCheck) {
            return this;
        }
        this.append(key, value, ',');
        return this;
    }

    public JsonStringBuilder appendEnd() {
        return this.appendEnd(true);
    }

    public JsonStringBuilder appendEnd(boolean isNewLine) {
        if (this.sb.charAt(this.sb.length() - 1) == ',') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        this.sb.append('}');
        if (isNewLine) {
            this.sb.append("\r\n");
        }
        return this;
    }

    public JsonStringBuilder appendEnd(String key, Object value) {
        return this.appendEnd(key, value, true);
    }

    public JsonStringBuilder appendEnd(String key, Object value, boolean isNewLine) {
        if (value == null) {
            if (this.isValueNullCheck) {
                return this.appendEnd(isNewLine);
            }
            this.append(key, value, '}');
        } else {
            this.append(key, value, '}');
        }
        if (isNewLine) {
            this.sb.append("\r\n");
        }
        return this;
    }

    private JsonStringBuilder append(String key, Object value, char endChar) {
        String valueStr;
        if (value == null) {
            this.sb.append('\"').append(key).append('\"').append(':').append('\"').append(value).append('\"').append(endChar);
            return this;
        }
        if (value instanceof String && ((valueStr = (String)value).length() <= 0 || valueStr.charAt(0) != '{' && valueStr.charAt(0) != '[')) {
            this.sb.append('\"').append(key).append('\"').append(':').append('\"').append(value).append('\"').append(endChar);
            return this;
        }
        this.sb.append('\"').append(key).append('\"').append(':').append(value).append(endChar);
        return this;
    }

    public JsonStringBuilder reset() {
        this.sb.delete(0, this.sb.length());
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

