/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.utils;

import com.alipay.common.tracer.core.appender.config.LogReserveConfig;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Map;
import java.util.TimeZone;

public class TracerUtils {
    private static int TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH = -1;
    private static int TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH = -1;
    public static final String KEY_OF_CURRENT_ZONE = "com.alipay.ldc.zone";
    public static final String CURRENT_ZONE = System.getProperty("com.alipay.ldc.zone");

    public static String getTraceId() {
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (currentSpan == null) {
            return "";
        }
        SofaTracerSpanContext sofaTracerSpanContext = currentSpan.getSofaTracerSpanContext();
        String traceId = null;
        if (sofaTracerSpanContext != null) {
            traceId = sofaTracerSpanContext.getTraceId();
        }
        return StringUtils.isBlank(traceId) ? "" : traceId;
    }

    public static boolean checkBaggageLength(SofaTracerSpan sofaTracerSpan, String key, String value) {
        int length = sofaTracerSpan.getSofaTracerSpanContext().getBizSerializedBaggage().length();
        length = sofaTracerSpan.getBaggageItem(key) == null ? (length += key.length() + value.length()) : (length += value.length() - sofaTracerSpan.getBaggageItem(key).length());
        length = length + "&".length() + "=".length();
        return length <= TracerUtils.getBaggageMaxLength();
    }

    public static int getSysBaggageMaxLength() {
        if (TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH < 0) {
            String length = SofaTracerConfiguration.getProperty("tracer_system_penetrate_attribute_max_length");
            if (StringUtils.isBlank(length)) {
                TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH = 1024;
            } else {
                try {
                    TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH = Integer.parseInt(length);
                }
                catch (NumberFormatException e) {
                    TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH = 1024;
                }
            }
        }
        return TRACER_SYSTEM_PENETRATE_ATTRIBUTE_MAX_LENGTH;
    }

    public static int getBaggageMaxLength() {
        if (TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH < 0) {
            String length = SofaTracerConfiguration.getProperty("tracer_penetrate_attribute_max_length");
            if (StringUtils.isBlank(length)) {
                TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH = 1024;
            } else {
                try {
                    TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH = Integer.parseInt(length);
                }
                catch (NumberFormatException e) {
                    TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH = 1024;
                }
            }
        }
        return TRACE_PENETRATE_ATTRIBUTE_MAX_LENGTH;
    }

    public static String getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isBlank(processName)) {
            return "";
        }
        String[] processSplitName = processName.split("@");
        if (processSplitName.length == 0) {
            return "";
        }
        String pid = processSplitName[0];
        if (StringUtils.isBlank(pid)) {
            return "";
        }
        return pid;
    }

    public static LogReserveConfig parseLogReserveConfig(String logReserveConfig) {
        if (StringUtils.isBlank(logReserveConfig)) {
            return new LogReserveConfig(7, 0);
        }
        int hour = 0;
        int dayIndex = logReserveConfig.indexOf("D");
        int day = dayIndex >= 0 ? Integer.valueOf(logReserveConfig.substring(0, dayIndex)).intValue() : Integer.valueOf(logReserveConfig).intValue();
        int hourIndex = logReserveConfig.indexOf("H");
        if (hourIndex >= 0) {
            hour = Integer.valueOf(logReserveConfig.substring(dayIndex + 1, hourIndex));
        }
        return new LogReserveConfig(day, hour);
    }

    public static boolean isLoadTest(SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null || sofaTracerSpan.getSofaTracerSpanContext() == null) {
            return false;
        }
        SofaTracerSpanContext spanContext = sofaTracerSpan.getSofaTracerSpanContext();
        Map<String, String> baggage = spanContext.getBizBaggage();
        return "T".equals(baggage.get("mark"));
    }

    public static String getLoadTestMark(SofaTracerSpan span) {
        if (TracerUtils.isLoadTest(span)) {
            return "T";
        }
        return "F";
    }

    public static String getInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String removeJSessionIdFromUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf(";jsessionid=");
        if (index < 0) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String getCurrentZone() {
        return CURRENT_ZONE;
    }

    public static String getDefaultTimeZone() {
        return TimeZone.getDefault().getID();
    }

    public static String getEmptyStringIfNull(Map<String, String> map, String key) {
        String value = map.get(key);
        return value == null ? "" : value;
    }

    public static String hostToHexString(String host) {
        return Integer.toHexString(host.hashCode());
    }
}

