/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class StringUtils {
    public static final String NEWLINE = "\r\n";
    public static final String EMPTY_STRING = "";
    public static final String EQUAL = "=";
    public static final String AND = "&";
    public static final char EQUAL_CHARACTER = '=';
    public static final char AND_CHARACTER = '&';
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String mapToStringWithPrefix(Map<String, String> map, String prefix) {
        StringBuilder sb = new StringBuilder(256);
        if (prefix == null) {
            prefix = EMPTY_STRING;
        }
        if (map == null) {
            sb.append(EMPTY_STRING);
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = prefix + StringUtils.escapePercentEqualAnd(entry.getKey());
                String val = StringUtils.escapePercentEqualAnd(entry.getValue());
                sb.append(key).append(EQUAL).append(val).append(AND);
            }
        }
        return sb.toString();
    }

    public static String mapToString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder(256);
        if (map == null || map.size() == 0) {
            sb.append(EMPTY_STRING);
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = StringUtils.escapePercentEqualAnd(entry.getKey());
                String val = StringUtils.escapePercentEqualAnd(entry.getValue());
                sb.append(key).append(EQUAL).append(val).append(AND);
            }
        }
        return sb.toString();
    }

    public static void stringToMap(String str, Map<String, String> map) {
        if (StringUtils.isBlank(str)) {
            return;
        }
        String key = null;
        String value = null;
        int mark = -1;
        block4: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    value = str.substring(mark + 1, i);
                    if (key != null) {
                        map.put(StringUtils.unescapeEqualAndPercent(key), StringUtils.unescapeEqualAndPercent(value));
                    }
                    key = null;
                    mark = i;
                    continue block4;
                }
                case '=': {
                    key = str.substring(mark + 1, i);
                    mark = i;
                    continue block4;
                }
            }
        }
        if (key != null) {
            int l = str.length() - mark - 1;
            value = l == 0 ? EMPTY_STRING : str.substring(mark + 1);
            map.put(key, StringUtils.unescapeEqualAndPercent(value));
        }
    }

    public static String escapeComma(String str) {
        return StringUtils.escape(str, ",", "%2C");
    }

    public static String unescapeComma(String str) {
        return StringUtils.escape(str, "%2C", ",");
    }

    public static String arrayToString(Object[] items, char separator, String prefix, String postfix) {
        String emptyArrayString = EMPTY_STRING + prefix + postfix;
        if (items == null) {
            return emptyArrayString;
        }
        if (items.length == 0) {
            return emptyArrayString;
        }
        Object first = items[0];
        if (items.length == 1) {
            return first == null ? emptyArrayString : prefix + first.toString() + postfix;
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append(prefix);
        if (first != null) {
            buf.append(first);
        }
        for (int i = 1; i < items.length; ++i) {
            buf.append(separator);
            Object obj = items[i];
            if (obj == null) continue;
            buf.append(obj);
        }
        buf.append(postfix);
        return buf.toString();
    }

    private static String escapePercentEqualAnd(String str) {
        return StringUtils.escape(StringUtils.escape(StringUtils.escape(str, "%", "%25"), AND, "%26"), EQUAL, "%3D");
    }

    private static String unescapeEqualAndPercent(String str) {
        return StringUtils.escape(StringUtils.escape(StringUtils.escape(str, "%3D", EQUAL), "%26", AND), "%25", "%");
    }

    private static String escape(String str, String oldStr, String newStr) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return str.replace(oldStr, newStr);
    }

    public static boolean hasText(CharSequence str) {
        if (StringUtils.isNotBlank(str.toString())) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = EMPTY_STRING;
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = EMPTY_STRING;
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, EMPTY_STRING, EMPTY_STRING);
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll == null || coll.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (EMPTY_STRING.equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.isBlank(inString) || StringUtils.isBlank(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringUtils.isBlank(inString) || StringUtils.isBlank(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static int countMatches(String str, char c) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }
}

