/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.mojo;

import com.alipay.sofa.boot.mojo.AbstractExecMojo;
import com.alipay.sofa.boot.vo.PropertiesFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="write", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class WriteVersionPropertiesMojo
extends AbstractExecMojo {
    private Log log = this.getLog();
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter
    private List<PropertiesFile> propertiesFiles;
    @Parameter(defaultValue="false")
    private boolean forceAddDefaultProperties = false;
    @Parameter(defaultValue="true")
    private boolean onlyAddDefaultPropertiesWhenNoCustom = true;
    @Parameter(defaultValue="sofa.versions.properties")
    private String defaultPropertiesFileName = "sofa.versions.properties";
    @Parameter(defaultValue="META-INF")
    private String defaultPropertiesFileRelativePath = "META-INF";
    @Parameter
    private LinkedHashMap<String, String> defaultPropertiesFileEntries;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.writePropertiesFiles();
        }
        catch (MojoFailureException e) {
            this.log.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void writePropertiesFiles() throws MojoFailureException, IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)"== write properties files.");
        }
        Charset sourceCharset = null != this.encoding ? Charset.forName(this.encoding) : Charset.defaultCharset();
        if (this.forceAddDefaultProperties) {
            if (this.log.isInfoEnabled()) {
                this.log.info((CharSequence)"Add default properties files when no custom.");
            }
            this.writeDefaultPropertiesFile(this.defaultPropertiesFileName, this.defaultPropertiesFileRelativePath, this.defaultPropertiesFileEntries, sourceCharset);
        }
        if (this.propertiesFiles != null && !this.propertiesFiles.isEmpty()) {
            for (PropertiesFile file : this.propertiesFiles) {
                if (this.defaultPropertiesFileName.equals(file.getName()) && this.defaultPropertiesFileRelativePath.equals(file.getRelativePath())) {
                    throw new MojoFailureException("Custom file is equals default properties file, please use defaultPropertiesFileName/defaultPropertiesFileRelativePath/defaultPropertiesFileEntries");
                }
                this.writePropertiesFile(file, sourceCharset);
            }
        } else if (!this.forceAddDefaultProperties && this.onlyAddDefaultPropertiesWhenNoCustom) {
            if (this.log.isInfoEnabled()) {
                this.log.info((CharSequence)"Only add default properties files when no custom.");
            }
            this.writeDefaultPropertiesFile(this.defaultPropertiesFileName, this.defaultPropertiesFileRelativePath, this.defaultPropertiesFileEntries, sourceCharset);
        }
    }

    private void writeDefaultPropertiesFile(String defaultFileName, String defaultFileRelativePath, LinkedHashMap<String, String> appendEntries, Charset sourceCharset) throws IOException, MojoFailureException {
        PropertiesFile defaultFile = new PropertiesFile();
        defaultFile.setName(defaultFileName);
        defaultFile.setRelativePath(defaultFileRelativePath);
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        Properties properties = this.project.getProperties();
        entries.put("GroupId", this.project.getGroupId());
        entries.put("ArtifactId", this.project.getArtifactId());
        entries.put("Version", this.project.getVersion());
        entries.put("Doc-Url", this.project.getUrl());
        entries.put("Commit-Id", properties.getProperty("commit.id.full", ""));
        entries.put("Commit-Time", properties.getProperty("commit.time", ""));
        entries.put("Build-Time", properties.getProperty("build.time", ""));
        if (appendEntries != null) {
            entries.putAll(appendEntries);
        }
        defaultFile.setEntries(entries);
        this.writePropertiesFile(defaultFile, sourceCharset);
    }

    private void writePropertiesFile(PropertiesFile file, Charset sourceCharset) throws MojoFailureException, IOException {
        String fileName = file.getName();
        if (fileName == null || fileName.isEmpty()) {
            throw new MojoFailureException("name of PropertiesFile is null.");
        }
        String relativePath = file.getRelativePath();
        if (relativePath == null || relativePath.isEmpty()) {
            throw new MojoFailureException("relativePath of PropertiesFile is null.");
        }
        File dir = new File(this.outputDirectory, relativePath);
        dir.mkdirs();
        File pf = new File(dir, fileName);
        this.writeFile(pf, file.getEntries(), sourceCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File pf, Map<String, String> entries, Charset charset) throws IOException {
        this.log.info((CharSequence)("write to " + pf.getAbsoluteFile() + " with " + charset.displayName() + ", values is" + entries.toString()));
        FileOutputStream out = null;
        FilterOutputStream bo = null;
        try {
            out = new FileOutputStream(pf);
            bo = new BufferedOutputStream(out);
            bo.write("# Generate by sofa-version-maven-plugin. \r\n".getBytes(charset));
            bo.write(("# FileName:" + pf.getName() + " \r\n").getBytes(charset));
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                String line = entry.getKey() + "=" + this.trimToEmpty(entry.getValue()) + "\r\n";
                bo.write(line.getBytes(charset));
            }
            ((BufferedOutputStream)bo).flush();
            out.flush();
        }
        finally {
            if (bo != null) {
                bo.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

