/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.git;

import com.alipay.sofa.boot.git.GitParser;
import com.alipay.sofa.boot.vo.GitInfo;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class JGitParser
implements GitParser {
    @Override
    public GitInfo parse(File dotGitDirectory, Log log, boolean ignore) throws Exception {
        Repository git = null;
        try {
            git = this.getGitRepository(dotGitDirectory);
        }
        catch (Exception e) {
            if (ignore) {
                log.warn((CharSequence)e.getMessage());
                return null;
            }
            throw e;
        }
        GitInfo gitInfo = new GitInfo();
        StoredConfig config = git.getConfig();
        String userName = config.getString("user", null, "name");
        String userEmail = config.getString("user", null, "email");
        String branchName = git.getBranch();
        RevCommit lastCommit = this.getLastCommit(git);
        if (lastCommit != null) {
            String lastCommitId = lastCommit.getId().getName();
            long lastCommitTime = lastCommit.getCommitterIdent().getWhen().getTime();
            String lastCommitUser = lastCommit.getAuthorIdent().getName();
            String lastCommitEmail = lastCommit.getAuthorIdent().getEmailAddress();
            gitInfo.setBuildUser(userName);
            gitInfo.setBuildEmail(userEmail);
            gitInfo.setBranchName(branchName);
            gitInfo.setLastCommitId(lastCommitId);
            gitInfo.setLastCommitUser(lastCommitUser);
            gitInfo.setLastCommitEmail(lastCommitEmail);
            gitInfo.setLastCommitTime(lastCommitTime);
        }
        return gitInfo;
    }

    private RevCommit getLastCommit(Repository git) throws Exception {
        RevWalk revWalk = new RevWalk(git);
        Ref headCommitReference = git.getRef("HEAD");
        ObjectId headObjectId = headCommitReference != null ? headCommitReference.getObjectId() : git.resolve("HEAD");
        if (headObjectId == null) {
            throw new Exception("Could not get HEAD Ref, are you sure have commits in the dotGitDirectory?");
        }
        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headObjectId);
        revWalk.markStart(headCommit);
        return headCommit;
    }

    private Repository getGitRepository(File dotGitDirectory) throws Exception {
        Repository repository;
        if (!dotGitDirectory.exists()) {
            throw new Exception("Could not create git repository. " + dotGitDirectory + " is not exists!");
        }
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new Exception("Could not initialize git repository...", e);
        }
        if (repository == null) {
            throw new Exception("Could not create git repository. Are you sure '" + dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }
}

