/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer;

import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceMethodInvoker;
import com.alipay.sofa.rpc.tracer.Tracers;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;

public class RestTracerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTracerAdapter.class);
    private static final String METHOD_TYPE_STRING = "_method_type_string";

    public static void storeTracerInfo(ClientRequestContext requestContext) {
        String appName;
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.getCurrentSpan();
        RpcInternalContext context = RpcInternalContext.getContext();
        if (clientSpan != null) {
            requestContext.getHeaders().add((Object)"new_rpc_trace_context", (Object)clientSpan.getSofaTracerSpanContext().serializeSpanContext());
        }
        if ((appName = (String)context.getAttachment("_app_name")) != null) {
            requestContext.getHeaders().add((Object)"app", (Object)appName);
        }
    }

    public static void serverReceived(NettyHttpRequest request) {
        block7: {
            try {
                SofaRequest sofaRequest = new SofaRequest();
                HttpHeaders headers = request.getHttpHeaders();
                String rpcTraceContext = headers.getHeaderString("new_rpc_trace_context");
                if (StringUtils.isNotBlank(rpcTraceContext)) {
                    sofaRequest.addRequestProp("new_rpc_trace_context", rpcTraceContext);
                } else {
                    String traceIdKey = headers.getHeaderString("SOFA-TraceId");
                    String rpcIdKey = headers.getHeaderString("SOFA-RpcId");
                    if (StringUtils.isEmpty(rpcIdKey)) {
                        rpcIdKey = (String)request.getUri().getQueryParameters().getFirst((Object)"sofaRpcId");
                    }
                    if (StringUtils.isEmpty(traceIdKey)) {
                        traceIdKey = (String)request.getUri().getQueryParameters().getFirst((Object)"sofaTraceId");
                    }
                    if (StringUtils.isNotEmpty(traceIdKey) && StringUtils.isNotEmpty(rpcIdKey)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("sofaTraceId", traceIdKey);
                        map.put("sofaRpcId", rpcIdKey);
                        String penAttrs = headers.getHeaderString("sofaPenAttrs");
                        map.put("sofaPenAttrs", penAttrs);
                        sofaRequest.addRequestProp("rpc_trace_context", map);
                    }
                }
                Tracers.serverReceived(sofaRequest);
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("the process of rest tracer server receive occur error ", t);
            }
        }
    }

    public static void serverFilter(ContainerRequestContext requestContext) {
        block7: {
            try {
                SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
                SofaTracerSpan serverSpan = sofaTraceContext.getCurrentSpan();
                if (serverSpan != null) {
                    RpcInternalContext context = RpcInternalContext.getContext();
                    SofaResourceMethodInvoker resourceMethodInvoker = (SofaResourceMethodInvoker)((PostMatchContainerRequestContext)requestContext).getResourceMethod();
                    SofaResourceFactory factory = resourceMethodInvoker.getResource();
                    String serviceName = factory.getServiceName();
                    String appName = factory.getAppName();
                    if (serviceName == null) {
                        serviceName = resourceMethodInvoker.getResourceClass().getName();
                    }
                    serverSpan.setTag("service", serviceName);
                    if (resourceMethodInvoker.getMethod() != null) {
                        serverSpan.setTag("method", resourceMethodInvoker.getMethod().getName());
                        context.setAttachment(METHOD_TYPE_STRING, resourceMethodInvoker.getMethod());
                    }
                    serverSpan.setTag("remote.ip", context.getRemoteHostName());
                    String remoteAppName = requestContext.getHeaderString("app");
                    if (StringUtils.isNotBlank(remoteAppName)) {
                        serverSpan.setTag("remote.app", remoteAppName);
                    }
                    serverSpan.setTag("protocol", "rest");
                    serverSpan.setTag("invoke.type", "sync");
                    if (appName == null) {
                        appName = (String)RpcRuntimeContext.get("appName");
                    }
                    serverSpan.setTag("local.app", appName);
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("the process of rest tracer server filter occur error ", t);
            }
        }
    }

    public static void serverSend(NettyHttpResponse response, Throwable throwable) {
        block9: {
            try {
                SofaRequest sofaRequest = new SofaRequest();
                SofaResponse sofaResponse = new SofaResponse();
                if (response == null) {
                    sofaResponse.setErrorMsg("rest path ends with /favicon.ico");
                } else if (throwable != null) {
                    if (response.getStatus() == 500) {
                        sofaResponse.setAppResponse(throwable);
                    } else {
                        sofaResponse.setErrorMsg(throwable.getMessage());
                    }
                    Object method = RpcInternalContext.getContext().getAttachment(METHOD_TYPE_STRING);
                    if (method != null) {
                        Class<?>[] parameterTypes = ((Method)method).getParameterTypes();
                        String[] methodTypeString = new String[parameterTypes.length];
                        for (int i = 0; i < methodTypeString.length; ++i) {
                            methodTypeString[i] = parameterTypes[i].getName();
                        }
                        sofaRequest.setMethodArgSigs(methodTypeString);
                    }
                }
                Tracers.serverSend(sofaRequest, sofaResponse, null);
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block9;
                LOGGER.warn("the process of rest tracer server send occur error ", t);
            }
        }
    }
}

