/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.mesh;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.mesh.MeshRegistryHelper;
import com.alipay.sofa.rpc.registry.mesh.client.MeshApiClient;
import com.alipay.sofa.rpc.registry.mesh.model.ApplicationInfoRequest;
import com.alipay.sofa.rpc.registry.mesh.model.ProviderMetaInfo;
import com.alipay.sofa.rpc.registry.mesh.model.PublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.SubscribeServiceResult;
import com.alipay.sofa.rpc.registry.mesh.model.UnPublishServiceRequest;
import com.alipay.sofa.rpc.registry.mesh.model.UnSubscribeServiceRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Extension(value="mesh")
public class MeshRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeshRegistry.class);
    private static final String VERSION = "4.0";
    private MeshApiClient client;
    private boolean inited;
    private boolean registedApp;

    protected MeshRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Class<MeshRegistry> clazz = MeshRegistry.class;
        synchronized (MeshRegistry.class) {
            if (!this.inited) {
                String address = this.registryConfig.getAddress();
                this.client = new MeshApiClient(address);
                this.inited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MeshRegistryHelper.buildMeshKey(config, server.getProtocol());
                ProviderInfo providerInfo = MeshRegistryHelper.convertProviderToProviderInfo(config, server);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00205", serviceName));
                }
                this.doRegister(appName, serviceName, providerInfo);
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, LogCodes.getLog("00206", serviceName));
            }
        }
    }

    protected void doRegister(String appName, String serviceName, ProviderInfo providerInfo) {
        this.registerAppInfoOnce(appName);
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, LogCodes.getLog("00201", serviceName));
        }
        PublishServiceRequest publishServiceRequest = new PublishServiceRequest();
        publishServiceRequest.setServiceName(serviceName);
        ProviderMetaInfo providerMetaInfo = new ProviderMetaInfo();
        providerMetaInfo.setProtocol(providerInfo.getProtocolType());
        providerMetaInfo.setSerializeType(providerInfo.getSerializationType());
        providerMetaInfo.setAppName(appName);
        providerMetaInfo.setVersion(VERSION);
        publishServiceRequest.setProviderMetaInfo(providerMetaInfo);
        this.client.publishService(publishServiceRequest);
    }

    @Override
    public void unRegister(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MeshRegistryHelper.buildMeshKey(config, server.getProtocol());
                ProviderInfo providerInfo = MeshRegistryHelper.convertProviderToProviderInfo(config, server);
                try {
                    this.doUnRegister(serviceName, providerInfo);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00203", serviceName, "1"));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("00203", serviceName, "0"), e);
                }
            }
        }
    }

    protected void doUnRegister(String serviceName, ProviderInfo providerInfo) {
        UnPublishServiceRequest unPublishServiceRequest = new UnPublishServiceRequest();
        unPublishServiceRequest.setServiceName(serviceName);
        this.client.unPublishService(unPublishServiceRequest);
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unregistry", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        this.registerAppInfoOnce(appName);
        String key = MeshRegistryHelper.buildMeshKey(config, config.getProtocol());
        SubscribeServiceRequest subscribeRequest = new SubscribeServiceRequest();
        subscribeRequest.setServiceName(key);
        SubscribeServiceResult subscribeServiceResult = this.client.subscribeService(subscribeRequest);
        if (subscribeServiceResult == null || !subscribeServiceResult.isSuccess()) {
            throw new RuntimeException("regist consumer occors error," + subscribeRequest);
        }
        ArrayList<ProviderGroup> providerGroups = new ArrayList<ProviderGroup>();
        ProviderGroup providerGroup = new ProviderGroup();
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        String url = this.fillProtocolAndVersion(subscribeServiceResult, this.client.getHost(), "");
        ProviderInfo providerInfo = ProviderHelper.toProviderInfo(url);
        providerInfos.add(providerInfo);
        providerGroup.setProviderInfos(providerInfos);
        providerGroups.add(providerGroup);
        return providerGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAppInfoOnce(String appName) {
        Class<MeshRegistry> clazz = MeshRegistry.class;
        synchronized (MeshRegistry.class) {
            if (!this.registedApp) {
                ApplicationInfoRequest applicationInfoRequest = this.buildApplicationRequest(appName);
                boolean registed = this.client.registeApplication(applicationInfoRequest);
                if (!registed) {
                    throw new RuntimeException("registe application occors error," + applicationInfoRequest);
                }
                this.registedApp = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected ApplicationInfoRequest buildApplicationRequest(String appName) {
        ApplicationInfoRequest applicationInfoRequest = new ApplicationInfoRequest();
        applicationInfoRequest.setAppName(appName);
        return applicationInfoRequest;
    }

    protected String fillProtocolAndVersion(SubscribeServiceResult subscribeServiceResult, String targetURL, String serviceName) {
        block1: {
            block0: {
                List<String> datas = subscribeServiceResult.getDatas();
                if (datas != null) break block0;
                targetURL = targetURL + ":" + 12220;
                break block1;
            }
            Iterator<String> i$ = subscribeServiceResult.getDatas().iterator();
            if (!i$.hasNext()) break block1;
            String data = i$.next();
            String param = data.substring(data.indexOf("?"));
            targetURL = targetURL + ":" + 12220;
            targetURL = targetURL + param;
        }
        return targetURL;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String key = MeshRegistryHelper.buildMeshKey(config, config.getProtocol());
        UnSubscribeServiceRequest unsubscribeRequest = new UnSubscribeServiceRequest();
        unsubscribeRequest.setServiceName(key);
        this.client.unSubscribeService(unsubscribeRequest);
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unSubscribe", e);
            }
        }
    }

    @Override
    public void destroy() {
        this.client = null;
    }
}

