/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.metrics.lookout;

import com.alipay.lookout.api.Counter;
import com.alipay.lookout.api.DistributionSummary;
import com.alipay.lookout.api.Gauge;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Lookout;
import com.alipay.lookout.api.Timer;
import com.alipay.lookout.api.composite.MixinMetric;
import com.alipay.lookout.api.info.Info;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.metrics.lookout.RpcAbstractLookoutModel;
import com.alipay.sofa.rpc.metrics.lookout.RpcClientLookoutModel;
import com.alipay.sofa.rpc.metrics.lookout.RpcLookoutId;
import com.alipay.sofa.rpc.metrics.lookout.RpcServerLookoutModel;
import java.util.HashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RpcLookout {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcLookout.class);
    private final RpcLookoutId rpcLookoutId = new RpcLookoutId();

    public void collectClient(RpcClientLookoutModel rpcClientMetricsModel) {
        try {
            Id methodConsumerId = this.createMethodConsumerId(rpcClientMetricsModel);
            MixinMetric methodConsumerMetric = Lookout.registry().mixinMetric(methodConsumerId);
            this.recordCounterAndTimer(methodConsumerMetric, rpcClientMetricsModel);
            this.recordSize(methodConsumerMetric, rpcClientMetricsModel);
        }
        catch (Throwable t) {
            LOGGER.error(LogCodes.getLog("04207"), t);
        }
    }

    public void collectServer(RpcServerLookoutModel rpcServerMetricsModel) {
        try {
            Id methodProviderId = this.createMethodProviderId(rpcServerMetricsModel);
            MixinMetric methodProviderMetric = Lookout.registry().mixinMetric(methodProviderId);
            this.recordCounterAndTimer(methodProviderMetric, rpcServerMetricsModel);
        }
        catch (Throwable t) {
            LOGGER.error(LogCodes.getLog("04207"), t);
        }
    }

    public void collectThreadPool(ServerConfig serverConfig, final ThreadPoolExecutor threadPoolExecutor) {
        try {
            int coreSize = serverConfig.getCoreThreads();
            int maxSize = serverConfig.getMaxThreads();
            int queueSize = serverConfig.getQueues();
            final ThreadPoolConfig threadPoolConfig = new ThreadPoolConfig(coreSize, maxSize, queueSize);
            Lookout.registry().info(this.rpcLookoutId.getServerThreadConfigId(serverConfig), (Info)new Info<ThreadPoolConfig>(){

                public ThreadPoolConfig value() {
                    return threadPoolConfig;
                }
            });
            Lookout.registry().gauge(this.rpcLookoutId.getServerThreadPoolActiveCountId(serverConfig), (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return threadPoolExecutor.getActiveCount();
                }
            });
            Lookout.registry().gauge(this.rpcLookoutId.getServerThreadPoolIdleCountId(serverConfig), (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return threadPoolExecutor.getPoolSize() - threadPoolExecutor.getActiveCount();
                }
            });
            Lookout.registry().gauge(this.rpcLookoutId.getServerThreadPoolQueueSizeId(serverConfig), (Gauge)new Gauge<Integer>(){

                public Integer value() {
                    return threadPoolExecutor.getQueue().size();
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error(LogCodes.getLog("04207"), t);
        }
    }

    public void removeThreadPool(ServerConfig serverConfig) {
        Lookout.registry().removeMetric(this.rpcLookoutId.removeServerThreadConfigId(serverConfig));
        Lookout.registry().removeMetric(this.rpcLookoutId.removeServerThreadPoolActiveCountId(serverConfig));
        Lookout.registry().removeMetric(this.rpcLookoutId.removeServerThreadPoolIdleCountId(serverConfig));
        Lookout.registry().removeMetric(this.rpcLookoutId.removeServerThreadPoolQueueSizeId(serverConfig));
    }

    private void recordCounterAndTimer(MixinMetric mixinMetric, RpcAbstractLookoutModel model) {
        Counter totalCounter = mixinMetric.counter("total_count");
        Timer totalTimer = mixinMetric.timer("total_time");
        Long elapsedTime = model.getElapsedTime();
        totalCounter.inc();
        if (elapsedTime != null) {
            totalTimer.record(elapsedTime.longValue(), TimeUnit.MILLISECONDS);
        }
        if (!model.getSuccess()) {
            Counter failCounter = mixinMetric.counter("fail_count");
            Timer failTimer = mixinMetric.timer("fail_time");
            failCounter.inc();
            if (elapsedTime != null) {
                failTimer.record(elapsedTime.longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private void recordSize(MixinMetric mixinMetric, RpcClientLookoutModel model) {
        Long requestSize = model.getRequestSize();
        Long responseSize = model.getResponseSize();
        if (requestSize != null) {
            DistributionSummary requestSizeDS = mixinMetric.distributionSummary("request_size");
            requestSizeDS.record(model.getRequestSize().longValue());
        }
        if (responseSize != null) {
            DistributionSummary responseSizeDS = mixinMetric.distributionSummary("response_size");
            responseSizeDS.record(model.getResponseSize().longValue());
        }
    }

    private Id createMethodConsumerId(RpcClientLookoutModel model) {
        HashMap<String, String> tags = new HashMap<String, String>(6);
        tags.put("app", StringUtils.defaultString(model.getApp()));
        tags.put("service", StringUtils.defaultString(model.getService()));
        tags.put("method", StringUtils.defaultString(model.getMethod()));
        tags.put("protocol", StringUtils.defaultString(model.getProtocol()));
        tags.put("invoke_type", StringUtils.defaultString(model.getInvokeType()));
        tags.put("target_app", StringUtils.defaultString(model.getTargetApp()));
        return this.rpcLookoutId.getConsumerId().withTags(tags);
    }

    public Id createMethodProviderId(RpcServerLookoutModel model) {
        HashMap<String, String> tags = new HashMap<String, String>(5);
        tags.put("app", StringUtils.defaultString(model.getApp()));
        tags.put("service", StringUtils.defaultString(model.getService()));
        tags.put("method", StringUtils.defaultString(model.getMethod()));
        tags.put("protocol", StringUtils.defaultString(model.getProtocol()));
        tags.put("caller_app", StringUtils.defaultString(model.getCallerApp()));
        return this.rpcLookoutId.getProviderId().withTags(tags);
    }

    private class ThreadPoolConfig {
        private int corePoolSize;
        private int maxPoolSize;
        private int queueSize;

        public ThreadPoolConfig(int corePoolSize, int maxPoolSize, int queueSize) {
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
            this.queueSize = queueSize;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }
}

