/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.log;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.Logger;

public class LoggerFactory {
    private static String implClass = RpcConfigs.getStringValue("logger.impl");

    public static Logger getLogger(String name) {
        try {
            return (Logger)ClassUtils.forName(implClass).getConstructor(String.class).newInstance(name);
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Error when getLogger of " + name + ", implement is " + implClass + "", e);
        }
    }

    public static Logger getLogger(Class clazz) {
        try {
            return (Logger)ClassUtils.forName(implClass).getConstructor(Class.class).newInstance(clazz);
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException("Error when getLogger of " + clazz.getName() + ", implement is " + implClass + "", e);
        }
    }
}

